/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.sql.Timestamp;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.organization.Query;

public class UserByQueryJCRUserListAccess
extends JCRUserListAccess {
    private Query query;

    public UserByQueryJCRUserListAccess(JCROrganizationServiceImpl service, Query query, boolean enabledOnly) throws RepositoryException {
        super(service, enabledOnly);
        this.query = query;
    }

    protected int getSize(Session session) throws Exception {
        this.iterator = this.createIterator(session);
        return (int)this.iterator.getSize();
    }

    private String removeAsterisk(String str) {
        if (str.startsWith("*")) {
            str = str.substring(1);
        }
        if (str.endsWith("*")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private QueryImpl makeQuery(Session session) throws InvalidQueryException, RepositoryException {
        StatementContext context = new StatementContext();
        context.statement = new StringBuilder("SELECT * FROM ");
        context.statement.append("jos:user-v2");
        if (this.query.getUserName() != null) {
            this.addStringStatement(context, "jos:userName", this.query.getUserName());
        }
        if (this.query.getFirstName() != null) {
            this.addStringStatement(context, "jos:firstName", this.query.getFirstName());
        }
        if (this.query.getLastName() != null) {
            this.addStringStatement(context, "jos:lastName", this.query.getLastName());
        }
        if (this.query.getEmail() != null) {
            this.addStringStatement(context, "jos:email", this.query.getEmail());
        }
        if (this.query.getFromLoginDate() != null) {
            this.addDateStatement(context, "jos:lastLoginTime", ">=", this.query.getFromLoginDate());
        }
        if (this.query.getToLoginDate() != null) {
            this.addDateStatement(context, "jos:lastLoginTime", "<=", this.query.getToLoginDate());
        }
        if (this.enabledOnly) {
            context.statement.append(" AND ").append("jos:disabled").append(" IS NULL");
        }
        return (QueryImpl)session.getWorkspace().getQueryManager().createQuery(context.statement.toString(), "sql");
    }

    private void addStringStatement(StatementContext context, String field, String value) {
        this.addStatement(context, "UPPER(" + field + ")", "like", "'%" + this.removeAsterisk(value).toUpperCase() + "%'");
    }

    private void addDateStatement(StatementContext context, String field, String operand, Date value) {
        String timeStamp = new Timestamp(value.getTime()).toString();
        this.addStatement(context, field, operand, "TIMESTAMP '" + timeStamp + "'");
    }

    private void addStatement(StatementContext context, String field, String operand, String value) {
        if (context.hasWhere) {
            context.statement.append(" AND");
        } else {
            context.hasWhere = true;
            context.statement.append(" WHERE");
        }
        context.statement.append(" " + field + " " + operand + " " + value);
    }

    protected boolean canReuseIterator() {
        return false;
    }

    protected NodeIterator createIterator(Session session) throws RepositoryException {
        QueryImpl query = this.makeQuery(session);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    protected Object readObject(Node node) throws Exception {
        return this.uHandler.readUser(node);
    }

    private class StatementContext {
        private StringBuilder statement;
        private boolean hasWhere;

        private StatementContext() {
        }
    }
}

