/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.ext.organization.JCROrgServiceHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeImpl;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeEventListenerHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipTypeHandlerImpl
extends JCROrgServiceHandler
implements MembershipTypeHandler,
MembershipTypeEventListenerHandler {
    protected final List<MembershipTypeEventListener> listeners = new ArrayList<MembershipTypeEventListener>();

    MembershipTypeHandlerImpl(JCROrganizationServiceImpl service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.createMembershipType(session, (MembershipTypeImpl)mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType createMembershipType(Session session, MembershipTypeImpl mt, boolean broadcast) throws Exception {
        Node storageTypesNode = this.utils.getMembershipTypeStorageNode(session);
        Node typeNode = storageTypesNode.addNode(mt.getName().equals("*") ? "jos:membershipTypeAny" : mt.getName());
        mt.setInternalId(typeNode.getUUID());
        if (broadcast) {
            this.preSave(mt, true);
        }
        this.writeMembershipType(mt, typeNode);
        session.save();
        this.putInCache(mt);
        if (broadcast) {
            this.postSave(mt, true);
        }
        return mt;
    }

    public MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType findMembershipType(String name) throws Exception {
        MembershipType mt = this.getFromCache(name);
        if (mt != null) {
            return mt;
        }
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.findMembershipType(session, name);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType findMembershipType(Session session, String name) throws Exception {
        Node membershipTypeNode;
        try {
            membershipTypeNode = this.utils.getMembershipTypeNode(session, name);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        MembershipType mt = this.readMembershipType(membershipTypeNode);
        this.putInCache(mt);
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MembershipType> findMembershipTypes() throws Exception {
        ArrayList<MembershipType> types = new ArrayList<MembershipType>();
        Session session = this.service.getStorageSession();
        try {
            NodeIterator membershipTypes = this.utils.getMembershipTypeStorageNode(session).getNodes();
            while (membershipTypes.hasNext()) {
                MembershipType type = this.readMembershipType(membershipTypes.nextNode());
                types.add(type);
            }
            Collections.sort(types, MembershipTypeHandler.COMPARATOR);
        }
        finally {
            session.logout();
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.removeMembershipType(session, name, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType removeMembershipType(Session session, String name, boolean broadcast) throws RepositoryException, Exception {
        Node membershipTypeNode = this.utils.getMembershipTypeNode(session, name);
        MembershipType type = this.readMembershipType(membershipTypeNode);
        if (broadcast) {
            this.preDelete(type);
        }
        this.removeMemberships(membershipTypeNode);
        membershipTypeNode.remove();
        session.save();
        this.removeFromCache(name);
        this.removeAllRelatedFromCache(name);
        if (broadcast) {
            this.postDelete(type);
        }
        return type;
    }

    private void removeMemberships(Node membershipTypeNode) throws Exception {
        PropertyIterator refTypes = membershipTypeNode.getReferences();
        while (refTypes.hasNext()) {
            Property refTypeProp = refTypes.nextProperty();
            Node refTypeNode = refTypeProp.getParent();
            Node refUserNode = refTypeNode.getParent();
            this.membershipHandler.removeMembership(refUserNode, refTypeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.saveMembershipType(session, (MembershipTypeImpl)mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    void migrateMembershipType(Node oldMembershipTypeNode) throws Exception {
        MembershipType membershipType = this.readMembershipType(oldMembershipTypeNode);
        if (this.findMembershipType(membershipType.getName()) != null) {
            this.removeMembershipType(membershipType.getName(), false);
        }
        this.createMembershipType(membershipType, false);
    }

    private MembershipType saveMembershipType(Session session, MembershipTypeImpl mType, boolean broadcast) throws Exception {
        String newType;
        String oldType;
        Node mtNode = this.getOrCreateMembershipTypeNode(session, mType);
        boolean isNew = mtNode.isNew();
        if (broadcast) {
            this.preSave(mType, isNew);
        }
        if (!(oldType = mtNode.getName().equals("jos:membershipTypeAny") ? "*" : mtNode.getName()).equals(newType = mType.getName())) {
            String oldPath = mtNode.getPath();
            String newPath = this.utils.getMembershipTypeNodePath(newType);
            session.move(oldPath, newPath);
            this.moveMembershipsInCache(oldType, newType);
            this.removeFromCache(oldType);
        }
        this.writeMembershipType(mType, mtNode);
        session.save();
        this.putInCache(mType);
        if (broadcast) {
            this.postSave(mType, isNew);
        }
        return mType;
    }

    private Node getOrCreateMembershipTypeNode(Session session, MembershipTypeImpl mType) throws Exception {
        try {
            return mType.getInternalId() != null ? session.getNodeByUUID(mType.getInternalId()) : this.utils.getMembershipTypeNode(session, mType.getName());
        }
        catch (ItemNotFoundException e) {
            return this.createNewMembershipTypeNode(session, mType);
        }
        catch (PathNotFoundException e) {
            return this.createNewMembershipTypeNode(session, mType);
        }
    }

    private Node createNewMembershipTypeNode(Session session, MembershipTypeImpl mType) throws Exception {
        Node storageTypesNode = this.utils.getMembershipTypeStorageNode(session);
        return storageTypesNode.addNode(mType.getName());
    }

    private MembershipType readMembershipType(Node node) throws Exception {
        MembershipTypeImpl mt = new MembershipTypeImpl();
        mt.setName(node.getName().equals("jos:membershipTypeAny") ? "*" : node.getName());
        mt.setInternalId(node.getUUID());
        mt.setDescription(this.utils.readString(node, "jos:description"));
        return mt;
    }

    private void writeMembershipType(MembershipType membershipType, Node mtNode) throws Exception {
        mtNode.setProperty("jos:description", membershipType.getDescription());
    }

    private MembershipType getFromCache(String name) {
        return (MembershipType)this.cache.get((Serializable)((Object)name), CacheHandler.CacheType.MEMBERSHIPTYPE);
    }

    private void removeFromCache(String name) {
        this.cache.remove((Serializable)((Object)name), CacheHandler.CacheType.MEMBERSHIPTYPE);
    }

    private void removeAllRelatedFromCache(String name) {
        this.cache.remove((Serializable)((Object)("mt=" + name)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void moveMembershipsInCache(String oldType, String newType) {
        this.cache.move((Serializable)((Object)("mt=" + oldType)), (Serializable)((Object)("mt=" + newType)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void putInCache(MembershipType mt) {
        this.cache.put((Serializable)((Object)mt.getName()), mt, CacheHandler.CacheType.MEMBERSHIPTYPE);
    }

    private void preSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preSave(type, isNew);
        }
    }

    private void postSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postSave(type, isNew);
        }
    }

    private void preDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preDelete(type);
        }
    }

    private void postDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postDelete(type);
        }
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public List<MembershipTypeEventListener> getMembershipTypeListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public static class MembershipTypeProperties {
        public static final String JOS_DESCRIPTION = "jos:description";
    }
}

