/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.weld;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import org.fakereplace.api.ClassChangeAware;
import org.fakereplace.classloading.ClassIdentifier;
import org.fakereplace.com.google.common.collect.MapMaker;
import org.fakereplace.integration.weld.javassist.WeldProxyClassLoadingDelegate;
import org.jboss.weld.bean.proxy.ProxyFactory;

public class WeldClassChangeAware
implements ClassChangeAware {
    private static final Field beanField;
    private static final Map<Object, ProxyFactory<?>> proxyFactories;

    public void beforeChange(Class<?>[] changed, ClassIdentifier[] added) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notify(Class<?>[] changed, ClassIdentifier[] added) {
        ClassLoader oldCl = null;
        WeldProxyClassLoadingDelegate.beginProxyRegeneration();
        try {
            HashSet changedClasses = new HashSet(Arrays.asList(changed));
            for (ProxyFactory<?> instance : proxyFactories.values()) {
                try {
                    Bean bean = (Bean)beanField.get(instance);
                    for (Class clazz : changedClasses) {
                        if (!bean.getTypes().contains(clazz)) continue;
                        Thread.currentThread().setContextClassLoader(bean.getBeanClass().getClassLoader());
                        instance.getProxyClass();
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            WeldProxyClassLoadingDelegate.endProxyRegeneration();
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public static void addProxyFactory(ProxyFactory<?> factory, Object bean) {
        proxyFactories.put(bean, factory);
    }

    static {
        proxyFactories = new MapMaker().weakKeys().makeMap();
        try {
            beanField = ProxyFactory.class.getDeclaredField("bean");
            beanField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

