/*
 * Decompiled with CFR 0.152.
 */
package org.fakereplace.integration.weld;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;
import org.fakereplace.integration.weld.WeldClassChangeAware;
import org.fakereplace.integration.weld.javassist.WeldProxyClassLoadingDelegate;
import org.fakereplace.logging.Logger;
import org.fakereplace.manip.MethodInvokationManipulator;
import org.fakereplace.transformation.FakereplaceTransformer;
import org.fakereplace.util.DescriptorUtils;

public class WeldClassTransformer
implements FakereplaceTransformer {
    private static final Logger log = Logger.getLogger(WeldClassTransformer.class);

    public boolean transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, ClassFile file) throws IllegalClassFormatException {
        if (file.getName().equals("org.jboss.weld.bean.proxy.ProxyFactory")) {
            for (MethodInfo method : file.getMethods()) {
                if (method.getName().equals("createProxyClass")) {
                    MethodInvokationManipulator methodInvokationManipulator = new MethodInvokationManipulator();
                    methodInvokationManipulator.replaceVirtualMethodInvokationWithStatic(ClassLoader.class.getName(), WeldProxyClassLoadingDelegate.class.getName(), "loadClass", "(Ljava/lang/String;)Ljava/lang/Class;", "(Ljava/lang/ClassLoader;Ljava/lang/String;)Ljava/lang/Class;", loader);
                    methodInvokationManipulator.replaceVirtualMethodInvokationWithStatic("org.jboss.weld.util.bytecode.ClassFileUtils", WeldProxyClassLoadingDelegate.class.getName(), "toClass", "(Ljavassist/bytecode/ClassFile;Ljava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;", "(Ljavassist/bytecode/ClassFile;Ljava/lang/ClassLoader;Ljava/security/ProtectionDomain;)Ljava/lang/Class;", loader);
                    methodInvokationManipulator.transformClass(file, loader, true);
                    return true;
                }
                if (!method.getName().equals("<init>")) continue;
                Integer beanArgument = null;
                int count = 0;
                for (String paramType : DescriptorUtils.descriptorStringToParameterArray((String)method.getDescriptor())) {
                    if (paramType.equals("javax/enterprise/inject/spi/Bean")) {
                        beanArgument = count;
                        break;
                    }
                    if (paramType.equals("D") || paramType.equals("J")) {
                        count += 2;
                        continue;
                    }
                    ++count;
                }
                if (beanArgument == null) {
                    log.error("Constructor org.jboss.weld.bean.proxy.ProxyFactory.<init>" + method.getDescriptor() + " does not have a bean parameter, proxies produced by this factory will not be reloadable");
                    continue;
                }
                Bytecode code = new Bytecode(file.getConstPool());
                code.addAload(0);
                code.addAload(beanArgument.intValue());
                code.addInvokestatic(WeldClassChangeAware.class.getName(), "addProxyFactory", "(Lorg/jboss/weld/bean/proxy/ProxyFactory;)V");
                CodeIterator it = method.getCodeAttribute().iterator();
                try {
                    it.skipConstructor();
                    it.insert(code.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }
}

