/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.GitHub;
import org.guvnor.ala.source.git.GitRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class RepositoryVisitorTest {
    private File tempPath;

    @Before
    public void setUp() throws IOException {
        this.tempPath = Files.createTempDirectory("yyy", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void repositoryVisitorDiffDeletedTest() throws IOException {
        GitHub gitHub = new GitHub();
        GitRepository repository = (GitRepository)gitHub.getRepository("mbarkley/appformer-playground", (Map)new HashMap<String, String>(){
            {
                this.put("out-dir", RepositoryVisitorTest.this.tempPath.getAbsolutePath());
            }
        });
        Source source = repository.getSource("master", new String[0]);
        InputStream pomStream = org.uberfire.java.nio.file.Files.newInputStream((Path)source.getPath().resolve("users-new").resolve("pom.xml"), (OpenOption[])new OpenOption[0]);
        MavenProject project = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        RepositoryVisitor repositoryVisitor = new RepositoryVisitor(source.getPath().resolve("users-new"), project.getName());
        System.out.println("Root: " + repositoryVisitor.getRoot().getAbsolutePath());
        Map identityHash = repositoryVisitor.getIdentityHash();
        URI originRepo = URI.create("git://" + repository.getName());
        JGitFileSystemProvider provider = (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)originRepo);
        JGitFileSystem origin = (JGitFileSystem)provider.getFileSystem(originRepo);
        JGitUtil.commit((Git)origin.gitRepo(), (String)"master", (String)"user1", (String)"user1@example.com", (String)"commitx", null, null, (boolean)false, (Map)new HashMap<String, File>(){
            {
                this.put("/users-new/file.txt", RepositoryVisitorTest.this.tempFile("temp"));
                this.put("/users-new/pom.xml", RepositoryVisitorTest.this.tempFile("hi there" + UUID.randomUUID().toString()));
            }
        });
        provider.delete(source.getPath().resolve("users-new").resolve("demo.iml"), new DeleteOption[0]);
        RepositoryVisitor newRepositoryVisitor = new RepositoryVisitor(source.getPath().resolve("users-new"), repositoryVisitor.getRoot().getAbsolutePath().trim(), false);
        System.out.println("Root: " + newRepositoryVisitor.getRoot().getAbsolutePath());
        Map newIdentityHash = newRepositoryVisitor.getIdentityHash();
        MapDifference difference = Maps.difference((Map)identityHash, (Map)newIdentityHash);
        Map entriesDiffering = difference.entriesDiffering();
        System.out.println(" Size of Differences: " + entriesDiffering.size());
        for (Object key : entriesDiffering.keySet()) {
            System.out.println("Different Value: " + (String)key);
        }
        Assert.assertEquals((long)1L, (long)entriesDiffering.size());
        Assert.assertNotNull(entriesDiffering.get("/users-new/pom.xml"));
        Map deletedFiles = difference.entriesOnlyOnLeft();
        System.out.println(" Size of Deleted Files: " + deletedFiles.size());
        for (String key : deletedFiles.keySet()) {
            System.out.println("Deleted File: " + key);
        }
        Assert.assertEquals((long)1L, (long)deletedFiles.size());
        Assert.assertNotNull(deletedFiles.get("/users-new/demo.iml"));
        Map addedFiles = difference.entriesOnlyOnRight();
        System.out.println(" Size of added Files: " + addedFiles.size());
        for (String key : addedFiles.keySet()) {
            System.out.println("Added File: " + key);
        }
        Assert.assertEquals((long)1L, (long)addedFiles.size());
        Assert.assertNotNull(addedFiles.get("/users-new/file.txt"));
    }

    public File tempFile(String content) throws IOException {
        File file = File.createTempFile("bar", "foo");
        FileOutputStream out = new FileOutputStream(file);
        if (content != null && !content.isEmpty()) {
            ((OutputStream)out).write(content.getBytes());
            out.flush();
        }
        ((OutputStream)out).close();
        return file;
    }
}

