/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import org.appformer.maven.integration.MavenRepository;
import org.eclipse.aether.artifact.Artifact;
import org.guvnor.ala.build.Binary;
import org.guvnor.ala.build.maven.config.MavenDependencyConfig;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.build.maven.model.impl.MavenBinaryImpl;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;

public class MavenDependencyConfigExecutor
implements FunctionConfigExecutor<MavenDependencyConfig, MavenBinary> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenDependencyConfigExecutor.class);
    private final BuildRegistry buildRegistry;

    @Inject
    public MavenDependencyConfigExecutor(BuildRegistry buildRegistry) {
        this.buildRegistry = buildRegistry;
    }

    public Optional<MavenBinary> apply(MavenDependencyConfig config) {
        String artifactId = config.getArtifact();
        PortablePreconditions.checkNotEmpty((String)"artifact parameter is mandatory", (String)artifactId);
        LOGGER.debug("Resolving Artifact: {}", (Object)artifactId);
        Artifact artifact = this.resolveArtifact(artifactId);
        if (artifact == null) {
            throw new RuntimeException("Cannot resolve Maven artifact. Look at the previous logs for more information.");
        }
        String absolutePath = artifact.getFile().getAbsolutePath();
        LOGGER.debug("Resolved Artifact path: {}", (Object)absolutePath);
        Path path = FileSystems.getFileSystem((URI)URI.create("file://default")).getPath(absolutePath, new String[0]);
        MavenBinaryImpl binary = new MavenBinaryImpl(path, artifact.getArtifactId(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        this.buildRegistry.registerBinary((Binary)binary);
        return Optional.of(binary);
    }

    public Class<? extends Config> executeFor() {
        return MavenDependencyConfig.class;
    }

    public String outputId() {
        return "binary";
    }

    public String inputId() {
        return "maven-dependency-config";
    }

    protected Artifact resolveArtifact(String artifactId) {
        return MavenRepository.getMavenRepository().resolveArtifact(artifactId);
    }
}

