/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.build.maven.executor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.config.MavenProjectConfig;
import org.guvnor.ala.build.maven.model.PlugIn;
import org.guvnor.ala.build.maven.model.impl.MavenProjectImpl;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProjectConfig;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.source.Source;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class MavenProjectConfigExecutor
implements BiFunctionConfigExecutor<Source, MavenProjectConfig, ProjectConfig> {
    private final SourceRegistry sourceRegistry;

    @Inject
    public MavenProjectConfigExecutor(SourceRegistry sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
    }

    public Optional<ProjectConfig> apply(Source source, MavenProjectConfig mavenProjectConfig) {
        Path projectRoot = source.getPath().resolve(mavenProjectConfig.getProjectDir());
        InputStream pomStream = Files.newInputStream((Path)projectRoot.resolve("pom.xml"), (OpenOption[])new OpenOption[0]);
        MavenProject project = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        Collection<PlugIn> buildPlugins = this.extractPlugins(project);
        String expectedBinary = project.getArtifact().getArtifactId() + "-" + project.getArtifact().getVersion() + "." + this.calculateExtension(project.getArtifact().getType());
        String _tempDir = mavenProjectConfig.getProjectTempDir().trim();
        RepositoryVisitor repositoryVisitor = _tempDir.isEmpty() ? new RepositoryVisitor(projectRoot, project.getName()) : new RepositoryVisitor(projectRoot, _tempDir, mavenProjectConfig.recreateTempDir());
        MavenProjectImpl mavenProject = new MavenProjectImpl(project.getId(), project.getArtifact().getType(), project.getName(), expectedBinary, source.getPath(), source.getPath().resolve(mavenProjectConfig.getProjectDir()), source.getPath().resolve("target").resolve(expectedBinary).toAbsolutePath(), repositoryVisitor.getRoot().getAbsolutePath(), buildPlugins);
        this.sourceRegistry.registerProject(source, (Project)mavenProject);
        return Optional.of(mavenProject);
    }

    private Collection<PlugIn> extractPlugins(MavenProject project) {
        ArrayList<PlugIn> result = new ArrayList<PlugIn>(project.getBuildPlugins().size());
        for (final Plugin plugin : project.getBuildPlugins()) {
            final Map<String, Object> config = this.extractConfig(plugin.getConfiguration());
            result.add(new PlugIn(){

                @Override
                public String getId() {
                    return plugin.getKey();
                }

                @Override
                public Map<String, ?> getConfiguration() {
                    return config;
                }
            });
        }
        return result;
    }

    private Map<String, Object> extractConfig(Object configuration) {
        if (configuration instanceof Xpp3Dom) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            this.extractConfig(result, (Xpp3Dom)configuration);
            if (result.containsKey("configuration")) {
                if (result.get("configuration") != null) {
                    return (Map)result.get("configuration");
                }
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    private void extractConfig(Map<String, Object> content, Xpp3Dom xmlData) {
        if (xmlData.getChildCount() > 0) {
            HashMap<String, Object> config = new HashMap<String, Object>(xmlData.getChildCount());
            for (Xpp3Dom child : xmlData.getChildren()) {
                this.extractConfig(config, child);
            }
            content.put(xmlData.getName(), config);
        } else {
            content.put(xmlData.getName(), xmlData.getValue());
        }
    }

    public Class<? extends Config> executeFor() {
        return MavenProjectConfig.class;
    }

    public String outputId() {
        return "project";
    }

    public String inputId() {
        return "maven-config";
    }

    private String calculateExtension(String artifactType) {
        return "kjar".equals(artifactType) ? "jar" : artifactType;
    }
}

