/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class FractionManifest {
    public static final String CLASSPATH_LOCATION = "META-INF/fraction-manifest.yaml";
    private String name;
    private String module;
    private String groupId;
    private String artifactId;
    private String version;
    private int stabilityIndex;
    private String stabilityLevel;
    private boolean internal;
    private List<String> dependencies = new ArrayList<String>();

    public FractionManifest() {
    }

    public FractionManifest(URL url) throws IOException {
        this.read(url);
    }

    public FractionManifest(InputStream in) throws IOException {
        this.read(in);
    }

    protected void read(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.read(in);
        }
    }

    protected void read(InputStream in) throws IOException {
        Map stability;
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(in);
        this.setName((String)data.get("name"));
        this.setModule((String)data.get("module"));
        this.setGroupId((String)data.get("groupId"));
        this.setArtifactId((String)data.get("artifactId"));
        this.setVersion((String)data.get("version"));
        this.setDependencies((Collection)data.get("dependencies"));
        Object internal = data.get("internal");
        if (internal != null) {
            this.setInternal((Boolean)internal);
        }
        if ((stability = (Map)data.get("stability")) != null) {
            this.setStabilityIndex((Integer)stability.get("index"));
            this.setStabilityLevel((String)stability.get("level"));
        }
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStabilityIndex() {
        return this.stabilityIndex;
    }

    public void setStabilityIndex(int stabilityIndex) {
        this.stabilityIndex = stabilityIndex;
    }

    public String getStabilityLevel() {
        return this.stabilityLevel;
    }

    public void setStabilityLevel(String stabilityLevel) {
        this.stabilityLevel = stabilityLevel;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public void setDependencies(Collection<String> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

