/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.config.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Map;
import org.guvnor.ala.build.maven.model.MavenProject;
import org.guvnor.ala.build.maven.model.PlugIn;
import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.docker.config.DockerProvisioningConfig;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAwareDockerProvisioningConfig
implements ContextAware,
DockerProvisioningConfig,
CloneableConfig<DockerProvisioningConfig> {
    @JsonIgnore
    private Map<String, ?> context;
    private String imageName = "${input.image-name}";
    private String portNumber = "${input.port-number}";
    private ProviderId providerId;
    private String dockerPullValue = "${input.docker-pull}";
    protected static final Logger LOG = LoggerFactory.getLogger(ContextAwareDockerProvisioningConfig.class);

    public ContextAwareDockerProvisioningConfig() {
        this.imageName = DockerProvisioningConfig.super.getImageName();
        this.portNumber = DockerProvisioningConfig.super.getPortNumber();
        this.dockerPullValue = DockerProvisioningConfig.super.getDockerPullValue();
    }

    public ContextAwareDockerProvisioningConfig(String imageName, String portNumber, ProviderId providerId, String dockerPullValue) {
        this.imageName = imageName;
        this.portNumber = portNumber;
        this.providerId = providerId;
        this.dockerPullValue = dockerPullValue;
    }

    @JsonIgnore
    public void setContext(Map<String, ?> context) {
        block3: {
            this.context = context;
            this.providerId = (ProviderId)this.context.get("docker-provider");
            try {
                Object _project = context.get("project");
                if (_project == null || !(_project instanceof MavenProject)) break block3;
                Collection plugIns = ((MavenProject)_project).getBuildPlugins();
                for (PlugIn plugIn : plugIns) {
                    if (!plugIn.getId().equals("io.fabric8:docker-maven-plugin")) continue;
                    Map _config = (Map)plugIn.getConfiguration().get("images");
                    this.imageName = this.getValue(_config, "image").get("name").toString();
                    this.portNumber = this.getValue(this.getValue(this.getValue(_config, "image"), "build"), "ports").get("port").toString();
                    break;
                }
            }
            catch (Exception ex) {
                LOG.warn("Error failing to parse Maven configuration for Docker Plugin: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private Map<String, Object> getValue(Map<String, Object> _config, String key) {
        return (Map)_config.get(key);
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public String getPortNumber() {
        return this.portNumber;
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public String getDockerPullValue() {
        return this.dockerPullValue;
    }

    public void setProviderId(ProviderId providerId) {
        this.providerId = providerId;
    }

    public void setDockerPullValue(String dockerPullValue) {
        this.dockerPullValue = dockerPullValue;
    }

    public String toString() {
        return "ContextAwareDockerProvisioningConfig{imageName=" + this.imageName + ", portNumber=" + this.portNumber + ", providerId=" + this.providerId + ", dockerPullValue=" + this.dockerPullValue + '}';
    }

    public DockerProvisioningConfig asNewClone(DockerProvisioningConfig origin) {
        return new ContextAwareDockerProvisioningConfig(origin.getImageName(), origin.getPortNumber(), origin.getProviderId(), origin.getDockerPullValue());
    }
}

