/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.service;

import com.spotify.docker.client.DockerException;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ContainerState;
import javax.inject.Inject;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.docker.model.DockerRuntimeState;
import org.guvnor.ala.exceptions.RuntimeOperationException;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.RuntimeManager;
import org.guvnor.ala.runtime.RuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerRuntimeManager
implements RuntimeManager {
    private final RuntimeRegistry runtimeRegistry;
    private final DockerAccessInterface docker;
    protected static final Logger LOG = LoggerFactory.getLogger(DockerRuntimeManager.class);

    @Inject
    public DockerRuntimeManager(RuntimeRegistry runtimeRegistry, DockerAccessInterface docker) {
        this.runtimeRegistry = runtimeRegistry;
        this.docker = docker;
    }

    public boolean supports(RuntimeId runtimeId) {
        return runtimeId instanceof DockerRuntime || this.runtimeRegistry.getRuntimeById(runtimeId.getId()) instanceof DockerRuntime;
    }

    public void start(RuntimeId runtimeId) throws RuntimeOperationException {
        DockerRuntime runtime = (DockerRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Starting container: " + runtimeId.getId());
            this.docker.getDockerClient(runtime.getProviderId()).startContainer(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error("Error Starting container: " + runtimeId.getId(), ex);
            throw new RuntimeOperationException("Error Starting container: " + runtimeId.getId(), ex);
        }
    }

    public void stop(RuntimeId runtimeId) throws RuntimeOperationException {
        DockerRuntime runtime = (DockerRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            LOG.info("Stopping container: " + runtimeId.getId());
            this.docker.getDockerClient(runtime.getProviderId()).stopContainer(runtime.getId(), 1);
            this.refresh(runtimeId);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error("Error Stopping container: " + runtimeId.getId(), ex);
            throw new RuntimeOperationException("Error Stopping container: " + runtimeId.getId(), ex);
        }
    }

    public void restart(RuntimeId runtimeId) throws RuntimeOperationException {
        DockerRuntime runtime = (DockerRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            this.docker.getDockerClient(runtime.getProviderId()).restartContainer(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error("Error Restarting container: " + runtimeId.getId(), ex);
            throw new RuntimeOperationException("Error Restarting container: " + runtimeId.getId(), ex);
        }
    }

    public void refresh(RuntimeId runtimeId) throws RuntimeOperationException {
        DockerRuntime runtime = (DockerRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            ContainerInfo containerInfo = this.docker.getDockerClient(runtime.getProviderId()).inspectContainer(runtime.getId());
            ContainerState state = containerInfo.state();
            String stateString = "Stopped";
            if (state.running().booleanValue() && !state.paused().booleanValue()) {
                stateString = "Running";
            } else if (state.paused().booleanValue()) {
                stateString = "Paused";
            } else if (state.restarting().booleanValue()) {
                stateString = "Restarting";
            } else if (state.oomKilled().booleanValue()) {
                stateString = "Killed";
            }
            DockerRuntime newRuntime = new DockerRuntime(runtime.getId(), runtime.getConfig(), runtime.getProviderId(), runtime.getEndpoint(), runtime.getInfo(), (RuntimeState)new DockerRuntimeState(stateString, state.startedAt().toString()));
            this.runtimeRegistry.registerRuntime((Runtime)newRuntime);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error("Error Refreshing container: " + runtimeId.getId(), ex);
            throw new RuntimeOperationException("Error Refreshing container: " + runtimeId.getId(), ex);
        }
    }

    public void pause(RuntimeId runtimeId) throws RuntimeOperationException {
        DockerRuntime runtime = (DockerRuntime)this.runtimeRegistry.getRuntimeById(runtimeId.getId());
        try {
            this.docker.getDockerClient(runtime.getProviderId()).pauseContainer(runtime.getId());
            this.refresh(runtimeId);
        }
        catch (DockerException | InterruptedException ex) {
            LOG.error("Error Pausing container: " + runtimeId.getId(), ex);
            throw new RuntimeOperationException("Error Pausing container: " + runtimeId.getId(), ex);
        }
    }
}

