/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.access.impl;

import io.fabric8.openshift.client.OpenShiftConfig;
import org.guvnor.ala.openshift.access.OpenShiftRuntimeId;
import org.guvnor.ala.openshift.access.impl.OpenShiftAccessInterfaceImpl;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.config.impl.OpenShiftProviderConfigImpl;
import org.junit.Assert;
import org.junit.Test;

public class OpenShiftAccessTest {
    @Test
    public void testGoodRuntimeId() {
        String expectedPrj = "myProject";
        String expectedSvc = "myService";
        String expectedApp = "myApplication";
        OpenShiftRuntimeId oldId = new OpenShiftRuntimeId("myProject", "myService", "myApplication");
        OpenShiftRuntimeId newId = OpenShiftRuntimeId.fromString((String)oldId.toString());
        Assert.assertEquals((Object)"myProject", (Object)newId.project());
        Assert.assertEquals((Object)"myService", (Object)newId.service());
        Assert.assertEquals((Object)"myApplication", (Object)newId.application());
        Assert.assertEquals((Object)oldId, (Object)newId);
    }

    @Test
    public void testBadRuntimeId() {
        String nullStr = null;
        String emptyStr = "";
        String blankStr = " ";
        String validStr = "valid";
        try {
            new OpenShiftRuntimeId(nullStr, "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("", "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId(" ", "valid", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", nullStr, "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", " ", "valid");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", nullStr);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", "");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new OpenShiftRuntimeId("valid", "valid", " ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testProviderConfig() {
        OpenShiftProviderConfigImpl providerConfig = new OpenShiftProviderConfigImpl().clear();
        providerConfig.setKubernetesMaster("https://localhost:8443");
        providerConfig.setKubernetesOapiVersion("v2");
        OpenShiftConfig clientConfig = OpenShiftAccessInterfaceImpl.buildOpenShiftConfig((OpenShiftProviderConfig)providerConfig);
        Assert.assertEquals((Object)"https://localhost:8443/", (Object)clientConfig.getMasterUrl());
        Assert.assertEquals((Object)"https://localhost:8443/oapi/v2/", (Object)clientConfig.getOpenShiftUrl());
    }
}

