/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.executor;

import java.io.File;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.openshift.access.OpenShiftAccessInterface;
import org.guvnor.ala.openshift.access.OpenShiftClient;
import org.guvnor.ala.openshift.access.impl.OpenShiftAccessInterfaceImpl;
import org.guvnor.ala.openshift.config.OpenShiftParameters;
import org.guvnor.ala.openshift.config.OpenShiftProperty;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.config.OpenShiftRuntimeConfig;
import org.guvnor.ala.openshift.config.impl.ContextAwareOpenShiftRuntimeExecConfig;
import org.guvnor.ala.openshift.config.impl.OpenShiftProviderConfigImpl;
import org.guvnor.ala.openshift.config.impl.OpenShiftRuntimeConfigImpl;
import org.guvnor.ala.openshift.dns.OpenShiftNameService;
import org.guvnor.ala.openshift.executor.OpenShiftProviderConfigExecutor;
import org.guvnor.ala.openshift.executor.OpenShiftRuntimeExecExecutor;
import org.guvnor.ala.openshift.model.OpenShiftRuntime;
import org.guvnor.ala.openshift.model.OpenShiftRuntimeEndpoint;
import org.guvnor.ala.openshift.service.OpenShiftRuntimeManager;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(OpenShiftExecutorTest.class);
    private File workDir;

    @Before
    public void setUp() throws Exception {
        this.workDir = Files.createTempDirectory(OpenShiftExecutorTest.class.getSimpleName() + "-", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteQuietly((File)this.workDir);
    }

    @Test
    public void testProviderConfigReuse() throws Exception {
        OpenShiftProviderConfigImpl providerConfig = new OpenShiftProviderConfigImpl().clear();
        providerConfig.setName(this.getClass().getSimpleName());
        providerConfig.setKubernetesMaster("https://ce-os-rhel-master.usersys.redhat.com:8443");
        providerConfig.setKubernetesAuthBasicUsername("admin");
        providerConfig.setKubernetesAuthBasicPassword("admin");
        OpenShiftClient client = new OpenShiftAccessInterfaceImpl().newOpenShiftClient((ProviderConfig)providerConfig);
        OpenShiftRuntimeConfigImpl runtimeConfigA = this.createRuntimeConfig("tpcr1");
        OpenShiftRuntimeConfigImpl runtimeConfigB = this.createRuntimeConfig("tpcr2");
        client.create((OpenShiftRuntimeConfig)runtimeConfigA);
        client.create((OpenShiftRuntimeConfig)runtimeConfigB);
        client.destroy(runtimeConfigA.getRuntimeId().toString());
        client.destroy(runtimeConfigB.getRuntimeId().toString());
    }

    private OpenShiftRuntimeConfigImpl createRuntimeConfig(String testName) throws Exception {
        String prjName = this.createProjectName(testName);
        String appName = "myapp";
        String svcName = "myapp-execserv";
        OpenShiftRuntimeConfigImpl runtimeConfig = new OpenShiftRuntimeConfigImpl();
        runtimeConfig.setProjectName(prjName);
        runtimeConfig.setServiceName("myapp-execserv");
        runtimeConfig.setApplicationName("myapp");
        runtimeConfig.setResourceSecretsUri(this.getUri("bpmsuite-app-secret.json"));
        runtimeConfig.setResourceStreamsUri(this.getUri("jboss-image-streams.json"));
        runtimeConfig.setResourceTemplateUri(this.getUri("bpmsuite70-execserv.json"));
        runtimeConfig.setResourceTemplateParamValues(new OpenShiftParameters().param("APPLICATION_NAME", "myapp").param("IMAGE_STREAM_NAMESPACE", prjName).param("KIE_ADMIN_PWD", "admin1!").param("KIE_SERVER_PWD", "execution1!").toString());
        return runtimeConfig;
    }

    @Test
    public void testPipelineAndLifecycle() throws Exception {
        String kieServerUrl;
        InMemoryRuntimeRegistry runtimeRegistry = new InMemoryRuntimeRegistry();
        OpenShiftAccessInterfaceImpl openshiftAccessInterface = new OpenShiftAccessInterfaceImpl();
        Stage providerConfig = StageUtil.config((String)"OpenShift Provider Config", s -> new OpenShiftProviderConfig(){});
        Stage runtimeExec = StageUtil.config((String)"OpenShift Runtime Config", s -> new ContextAwareOpenShiftRuntimeExecConfig());
        Pipeline pipe = PipelineFactory.startFrom((Stage)providerConfig).andThen(runtimeExec).buildAs("my pipe");
        OpenShiftRuntimeExecExecutor openshiftRuntimeExecExecutor = new OpenShiftRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (OpenShiftAccessInterface)openshiftAccessInterface);
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new OpenShiftProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), openshiftRuntimeExecExecutor));
        final String pvrName = this.getClass().getSimpleName();
        final String prjName = this.createProjectName("tpal1");
        String appName = "myapp";
        String svcName = "myapp-execserv";
        String kieServerUser = "executionUser";
        String kieServerPwd = "execution1!";
        final String templateParams = new OpenShiftParameters().param("APPLICATION_NAME", "myapp").param("IMAGE_STREAM_NAMESPACE", prjName).param("KIE_ADMIN_PWD", "admin1!").param("KIE_SERVER_USER", "executionUser").param("KIE_SERVER_PWD", "execution1!").param("MAVEN_REPO_URL", "http://repository.jboss.org/nexus/content/groups/public/").toString();
        Input input = new Input(){
            {
                this.put(OpenShiftProperty.KUBERNETES_MASTER.inputKey(), "https://ce-os-rhel-master.usersys.redhat.com:8443");
                this.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_USERNAME.inputKey(), "admin");
                this.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_PASSWORD.inputKey(), "admin");
                this.put(OpenShiftProperty.PROVIDER_NAME.inputKey(), pvrName);
                this.put(OpenShiftProperty.APPLICATION_NAME.inputKey(), "myapp");
                this.put(OpenShiftProperty.PROJECT_NAME.inputKey(), prjName);
                this.put(OpenShiftProperty.RESOURCE_SECRETS_URI.inputKey(), OpenShiftExecutorTest.this.getUri("bpmsuite-app-secret.json"));
                this.put(OpenShiftProperty.RESOURCE_STREAMS_URI.inputKey(), OpenShiftExecutorTest.this.getUri("jboss-image-streams.json"));
                this.put(OpenShiftProperty.RESOURCE_TEMPLATE_PARAM_VALUES.inputKey(), templateParams);
                this.put(OpenShiftProperty.RESOURCE_TEMPLATE_URI.inputKey(), OpenShiftExecutorTest.this.getUri("bpmsuite70-execserv.json"));
                this.put(OpenShiftProperty.SERVICE_NAME.inputKey(), "myapp-execserv");
            }
        };
        executor.execute(input, pipe, b -> System.out.println(b), new PipelineEventListener[0]);
        OpenShiftRuntimeManager runtimeManager = new OpenShiftRuntimeManager((RuntimeRegistry)runtimeRegistry, (OpenShiftAccessInterface)openshiftAccessInterface);
        OpenShiftRuntime openshiftRuntime = this.getRuntime((RuntimeRegistry)runtimeRegistry, runtimeManager, null, true);
        Assert.assertEquals((Object)"READY", (Object)openshiftRuntime.getState().getState());
        runtimeManager.start((RuntimeId)openshiftRuntime);
        openshiftRuntime = this.getRuntime((RuntimeRegistry)runtimeRegistry, runtimeManager, openshiftRuntime, true);
        Assert.assertEquals((Object)"RUNNING", (Object)openshiftRuntime.getState().getState());
        RuntimeEndpoint runtimeEndpoint = openshiftRuntime.getEndpoint();
        Assert.assertTrue((boolean)(runtimeEndpoint instanceof OpenShiftRuntimeEndpoint));
        OpenShiftRuntimeEndpoint openshiftRuntimeEndpoint = (OpenShiftRuntimeEndpoint)runtimeEndpoint;
        String kieServerHost = openshiftRuntimeEndpoint.getHost();
        if (OpenShiftNameService.isHostRegistered(kieServerHost) && this.checkConnection(kieServerUrl = openshiftRuntimeEndpoint.getProtocol() + "://" + kieServerHost + "/services/rest/server")) {
            KieServicesConfiguration kieServicesConfig = KieServicesFactory.newRestConfiguration((String)kieServerUrl, (String)"executionUser", (String)"execution1!");
            KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)kieServicesConfig);
            ServiceResponse serverInfoResponse = kieServicesClient.getServerInfo();
            Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)serverInfoResponse.getType());
        }
        runtimeManager.stop((RuntimeId)openshiftRuntime);
        openshiftRuntime = this.getRuntime((RuntimeRegistry)runtimeRegistry, runtimeManager, openshiftRuntime, true);
        Assert.assertEquals((Object)"READY", (Object)openshiftRuntime.getState().getState());
        openshiftRuntimeExecExecutor.destroy((RuntimeId)openshiftRuntime);
        openshiftRuntime = this.getRuntime((RuntimeRegistry)runtimeRegistry, runtimeManager, openshiftRuntime, false);
        Assert.assertNull((Object)openshiftRuntime);
        openshiftAccessInterface.dispose();
    }

    private OpenShiftRuntime getRuntime(RuntimeRegistry runtimeRegistry, OpenShiftRuntimeManager runtimeManager, OpenShiftRuntime openshiftRuntime, boolean expected) {
        if (openshiftRuntime != null) {
            runtimeManager.refresh((RuntimeId)openshiftRuntime);
        }
        if (expected) {
            List allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
            Assert.assertEquals((long)1L, (long)allRuntimes.size());
            Runtime runtime = (Runtime)allRuntimes.get(0);
            Assert.assertTrue((boolean)(runtime instanceof OpenShiftRuntime));
            return (OpenShiftRuntime)runtime;
        }
        return null;
    }

    private String getUri(String resourcePath) throws URISyntaxException {
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        return this.getClass().getResource(resourcePath).toURI().toString();
    }

    private String createProjectName(String testName) {
        return System.getProperty("user.name", "anon").replaceAll("[^A-Za-z0-9]", "-") + '-' + (testName != null ? testName : "test") + '-' + new SimpleDateFormat("YYYYMMddHHmmss").format(new Date());
    }

    private boolean checkConnection(String url) throws Exception {
        return OpenShiftExecutorTest.checkConnection(new URL(url), 401, 1, 1000L);
    }

    static boolean checkConnection(URL url, int expectedResponse, int maxAttempts, long sleepMillis) throws Exception {
        boolean reachable = false;
        for (int i = 0; i < maxAttempts; ++i) {
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                int actualResponse = conn.getResponseCode();
                String logMsg = String.format("%s response code: %s", url, actualResponse);
                if (actualResponse == expectedResponse) {
                    LOG.info(logMsg);
                    reachable = true;
                    break;
                }
                LOG.warn(logMsg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Thread.sleep(sleepMillis);
        }
        if (!reachable) {
            LOG.warn(String.format("%s is not reachable.", url));
        }
        return reachable;
    }
}

