/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.backend.handler;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.openshift.config.OpenShiftProperty;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.config.impl.OpenShiftProviderConfigImpl;
import org.guvnor.ala.ui.backend.service.converter.ProviderConfigConverter;
import org.guvnor.ala.ui.backend.service.util.ServiceUtil;
import org.guvnor.ala.ui.model.ProviderConfiguration;

@ApplicationScoped
public class OpenShiftProviderConfigConverter
implements ProviderConfigConverter<ProviderConfiguration, OpenShiftProviderConfig> {
    public Class<ProviderConfiguration> getModelType() {
        return ProviderConfiguration.class;
    }

    public Class<OpenShiftProviderConfig> getDomainType() {
        return OpenShiftProviderConfig.class;
    }

    public OpenShiftProviderConfig toDomain(ProviderConfiguration modelValue) {
        if (modelValue == null) {
            return null;
        }
        OpenShiftProviderConfigImpl openShiftProviderConfig = new OpenShiftProviderConfigImpl();
        openShiftProviderConfig.clear();
        openShiftProviderConfig.setName(modelValue.getId());
        openShiftProviderConfig.setKubernetesMaster(ServiceUtil.getStringValue((Map)modelValue.getValues(), (String)OpenShiftProperty.KUBERNETES_MASTER.inputKey()));
        openShiftProviderConfig.setKubernetesAuthBasicUsername(ServiceUtil.getStringValue((Map)modelValue.getValues(), (String)OpenShiftProperty.KUBERNETES_AUTH_BASIC_USERNAME.inputKey()));
        openShiftProviderConfig.setKubernetesAuthBasicPassword(ServiceUtil.getStringValue((Map)modelValue.getValues(), (String)OpenShiftProperty.KUBERNETES_AUTH_BASIC_PASSWORD.inputKey()));
        return openShiftProviderConfig;
    }

    public ProviderConfiguration toModel(OpenShiftProviderConfig domainValue) {
        if (domainValue == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("provider-name", domainValue.getName());
        values.put(OpenShiftProperty.KUBERNETES_MASTER.inputKey(), domainValue.getKubernetesMaster());
        values.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_USERNAME.inputKey(), domainValue.getKubernetesAuthBasicUsername());
        values.put(OpenShiftProperty.KUBERNETES_AUTH_BASIC_PASSWORD.inputKey(), domainValue.getKubernetesAuthBasicPassword());
        return new ProviderConfiguration(domainValue.getName(), values);
    }
}

