/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.openshift.client.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class OSEProviderConfigPresenter
extends AbstractHasContentChangeHandlers
implements ProviderConfigurationForm {
    protected static final String MASTER_URL = "master-url";
    protected static final String USER = "username";
    protected static final String PASSWORD = "password";
    protected static final String PASSWORD_MASK = "****";
    private final View view;

    @Inject
    public OSEProviderConfigPresenter(View view) {
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public ProviderConfiguration buildProviderConfiguration() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(MASTER_URL, this.getMasterURL());
        values.put(USER, this.getUsername());
        values.put(PASSWORD, this.getPassword());
        return new ProviderConfiguration(this.getProviderName(), values);
    }

    public void clear() {
        this.view.clear();
    }

    public void load(Provider provider) {
        this.clear();
        this.view.setProviderName(((ProviderKey)provider.getKey()).getId());
        this.view.setMasterURL(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)MASTER_URL));
        this.view.setUsername(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)USER));
        this.view.setPassword(PASSWORD_MASK);
    }

    public String getProviderName() {
        return this.view.getProviderName();
    }

    public String getMasterURL() {
        return this.view.getMasterURL();
    }

    public String getUsername() {
        return this.view.getUsername();
    }

    public String getPassword() {
        return this.view.getPassword();
    }

    public void isValid(Callback<Boolean> callback) {
        callback.callback((Object)false);
    }

    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    public void disable() {
        this.view.disable();
    }

    protected void onProviderNameChange() {
        if (!this.isEmpty(this.view.getProviderName())) {
            this.view.setProviderNameStatus(FormStatus.VALID);
        } else {
            this.view.setProviderNameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onMasterURLChange() {
        if (!this.isEmpty(this.view.getMasterURL())) {
            this.view.setMasterURLStatus(FormStatus.VALID);
        } else {
            this.view.setMasterURLStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onUserNameChange() {
        if (!this.isEmpty(this.view.getUsername())) {
            this.view.setUsernameStatus(FormStatus.VALID);
        } else {
            this.view.setUsernameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onPasswordChange() {
        if (!this.isEmpty(this.view.getPassword())) {
            this.view.setPasswordStatus(FormStatus.VALID);
        } else {
            this.view.setPasswordStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private void onContentChange() {
        this.fireChangeHandlers();
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static interface View
    extends UberElement<OSEProviderConfigPresenter> {
        public String getProviderName();

        public String getMasterURL();

        public String getUsername();

        public String getPassword();

        public void setProviderName(String var1);

        public void setMasterURL(String var1);

        public void setUsername(String var1);

        public void setPassword(String var1);

        public void disable();

        public void enable();

        public void setProviderNameStatus(FormStatus var1);

        public void setMasterURLStatus(FormStatus var1);

        public void setUsernameStatus(FormStatus var1);

        public void setPasswordStatus(FormStatus var1);

        public void clear();

        public String getWizardTitle();
    }
}

