/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.provisioning.pipelines.openshift;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.guvnor.ala.openshift.config.OpenShiftProviderConfig;
import org.guvnor.ala.openshift.config.impl.ContextAwareOpenShiftRuntimeExecConfig;
import org.guvnor.ala.openshift.model.OpenShiftProviderType;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.SystemPipelineDescriptor;
import org.guvnor.ala.runtime.providers.ProviderType;

@ApplicationScoped
public class ProvisioningPipelinesProducer {
    @Produces
    public SystemPipelineDescriptor getKieServerProvisioningPipeline() {
        return new SystemPipelineDescriptor(){

            public Optional<ProviderType> getProviderType() {
                return Optional.of(OpenShiftProviderType.instance());
            }

            public Pipeline getPipeline() {
                Stage providerConfig = StageUtil.config((String)"OpenShift Provider Config", s -> new OpenShiftProviderConfig(){});
                Stage runtimeExec = StageUtil.config((String)"OpenShift Runtime Config", s -> new ContextAwareOpenShiftRuntimeExecConfig());
                Pipeline pipeline = PipelineFactory.startFrom((Stage)providerConfig).andThen(runtimeExec).buildAs("kie-server-provisioning");
                return pipeline;
            }
        };
    }
}

