/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.local;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.registry.PipelineRegistry;
import org.guvnor.ala.registry.local.utils.PageSortUtils;

@ApplicationScoped
public class InMemoryPipelineRegistry
implements PipelineRegistry {
    private final Map<String, Pipeline> pipelineByName = new ConcurrentHashMap<String, Pipeline>();

    public void registerPipeline(Pipeline pipeline) {
        this.pipelineByName.put(pipeline.getName(), pipeline);
    }

    public Pipeline getPipelineByName(String pipelineName) {
        return this.pipelineByName.get(pipelineName);
    }

    public List<Pipeline> getPipelines(int page, int pageSize, String sort, boolean sortOrder) {
        Collection<Pipeline> values = this.pipelineByName.values();
        return PageSortUtils.pageSort(values, (p1, p2) -> {
            switch (sort) {
                case "name": {
                    return p1.getName().compareTo(p2.getName());
                }
            }
            return p1.toString().compareTo(p2.toString());
        }, page, pageSize, sort, sortOrder);
    }
}

