/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest;

import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.PipelineRegistry;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.exceptions.BusinessException;

@ApplicationScoped
public class RestPipelineServiceImpl
implements PipelineService {
    @Inject
    private PipelineRegistry pipelineRegistry;
    @Inject
    private SourceRegistry sourceRegistry;
    @Inject
    private BuildRegistry buildRegistry;
    @Inject
    @Any
    private Instance<ConfigExecutor> configExecutors;
    @Inject
    private PipelineExecutor executor;
    @Inject
    @Any
    private Instance<PipelineEventListener> _eventListeners;
    private PipelineEventListener[] eventListeners;

    @PostConstruct
    public void init() {
        Iterator iterator = this.configExecutors.iterator();
        ArrayList<ConfigExecutor> configs = new ArrayList<ConfigExecutor>();
        while (iterator.hasNext()) {
            ConfigExecutor configExecutor = (ConfigExecutor)iterator.next();
            configs.add(configExecutor);
        }
        this.executor.init(configs);
        ArrayList<PipelineEventListener> eventListeners = new ArrayList<PipelineEventListener>();
        for (PipelineEventListener eventListener : this._eventListeners) {
            eventListeners.add(eventListener);
        }
        this.eventListeners = eventListeners.toArray(new PipelineEventListener[0]);
    }

    public PipelineConfigsList getPipelineConfigs(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        ArrayList configs = new ArrayList();
        this.pipelineRegistry.getPipelines(page.intValue(), pageSize.intValue(), sort, sortOrder).stream().forEach(p -> configs.add(p.getConfig()));
        return new PipelineConfigsList(configs);
    }

    public String newPipeline(PipelineConfig config) throws BusinessException {
        Pipeline pipeline = PipelineFactory.startFrom(null).build(config);
        this.pipelineRegistry.registerPipeline(pipeline);
        return config.getName();
    }

    public void runPipeline(String name, Input input) throws BusinessException {
        Pipeline pipe = this.pipelineRegistry.getPipelineByName(name);
        this.executor.execute(input, pipe, System.out::println, this.eventListeners);
    }
}

