/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest.tests;

import java.util.ArrayList;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.SystemPipelineDescriptor;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.backend.PipelineConfigImpl;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.wildfly.model.WildflyProviderType;

@ApplicationScoped
public class MockSystemPipelines {
    public static final String SYSTEM_PIPELINE1 = "system-pipeline1";
    public static final String SYSTEM_PIPELINE2 = "system-pipeline2";

    @Produces
    public SystemPipelineDescriptor getSystemPipeline1() {
        return new SystemPipelineDescriptor(){

            public Optional<ProviderType> getProviderType() {
                return Optional.of(WildflyProviderType.instance());
            }

            public Pipeline getPipeline() {
                return MockSystemPipelines.this.createDummyPipeline(MockSystemPipelines.SYSTEM_PIPELINE1);
            }
        };
    }

    @Produces
    public SystemPipelineDescriptor getSystemPipeline2() {
        return new SystemPipelineDescriptor(){

            public Optional<ProviderType> getProviderType() {
                return Optional.empty();
            }

            public Pipeline getPipeline() {
                return MockSystemPipelines.this.createDummyPipeline(MockSystemPipelines.SYSTEM_PIPELINE2);
            }
        };
    }

    private Pipeline createDummyPipeline(String pipelineName) {
        GitConfigImpl gitConfig = new GitConfigImpl();
        ArrayList<GitConfigImpl> configs = new ArrayList<GitConfigImpl>();
        configs.add(gitConfig);
        PipelineConfigImpl pipelineConfig = new PipelineConfigImpl(pipelineName, configs);
        Pipeline pipeline = PipelineFactory.startFrom(null).build((PipelineConfig)pipelineConfig);
        return pipeline;
    }
}

