/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest.tests;

import com.spotify.docker.client.DockerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.config.MavenBuildConfig;
import org.guvnor.ala.build.maven.config.MavenProjectConfig;
import org.guvnor.ala.build.maven.config.impl.MavenBuildConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenBuildExecConfigImpl;
import org.guvnor.ala.build.maven.config.impl.MavenProjectConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenBuildConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenBuildExecConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenProjectConfigExecutor;
import org.guvnor.ala.config.BuildConfig;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProjectConfig;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.docker.access.impl.DockerAccessInterfaceImpl;
import org.guvnor.ala.docker.config.DockerProviderConfig;
import org.guvnor.ala.docker.config.DockerRuntimeConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerProvisioningConfig;
import org.guvnor.ala.docker.config.impl.ContextAwareDockerRuntimeExecConfig;
import org.guvnor.ala.docker.config.impl.DockerBuildConfigImpl;
import org.guvnor.ala.docker.config.impl.DockerProviderConfigImpl;
import org.guvnor.ala.docker.executor.DockerBuildConfigExecutor;
import org.guvnor.ala.docker.executor.DockerProviderConfigExecutor;
import org.guvnor.ala.docker.executor.DockerProvisioningConfigExecutor;
import org.guvnor.ala.docker.executor.DockerRuntimeExecExecutor;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.docker.model.DockerProviderType;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.docker.service.DockerRuntimeManager;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImpl;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryBuildRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemorySourceRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeManager;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderBuilder;
import org.guvnor.ala.runtime.providers.ProviderDestroyer;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.PipelineService;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.RuntimeQueryBuilder;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.backend.PipelineConfigImpl;
import org.guvnor.ala.services.api.itemlist.PipelineConfigsList;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.api.itemlist.RuntimeQueryResultItemList;
import org.guvnor.ala.services.rest.RestPipelineServiceImpl;
import org.guvnor.ala.services.rest.RestRuntimeProvisioningServiceImpl;
import org.guvnor.ala.services.rest.factories.ProviderFactory;
import org.guvnor.ala.services.rest.factories.RuntimeFactory;
import org.guvnor.ala.services.rest.factories.RuntimeManagerFactory;
import org.guvnor.ala.services.rest.tests.MockPipelineEventListener;
import org.guvnor.ala.services.rest.tests.MockSystemPipelines;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.guvnor.ala.wildfly.executor.WildflyProviderConfigExecutor;
import org.guvnor.ala.wildfly.model.WildflyProviderType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.commons.lifecycle.Disposable;

@RunWith(value=Arquillian.class)
public class RestPipelineImplTest {
    @Inject
    private PipelineService pipelineService;
    @Inject
    private RuntimeProvisioningService runtimeService;
    private File tempPath;
    @Inject
    private MockPipelineEventListener listener;

    @Deployment
    public static Archive createDeployment() throws Exception {
        JavaArchive deployment = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        deployment.addClass(PipelineService.class);
        deployment.addClass(RestPipelineServiceImpl.class);
        deployment.addClass(PipelineExecutor.class);
        deployment.addClass(InMemoryPipelineRegistry.class);
        deployment.addClass(InMemoryBuildRegistry.class);
        deployment.addClass(InMemorySourceRegistry.class);
        deployment.addClass(DockerProviderConfigExecutor.class);
        deployment.addClass(WildflyProviderConfigExecutor.class);
        deployment.addClass(RestRuntimeProvisioningServiceImpl.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(InMemoryRuntimeRegistry.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(ProviderFactory.class);
        deployment.addClass(RuntimeFactory.class);
        deployment.addClass(RuntimeManagerFactory.class);
        deployment.addClass(DockerProviderType.class);
        deployment.addClass(DockerProviderConfig.class);
        deployment.addClass(DockerProvider.class);
        deployment.addClass(WildflyProviderType.class);
        deployment.addClass(ProviderBuilder.class);
        deployment.addClass(ProviderType.class);
        deployment.addClass(FunctionConfigExecutor.class);
        deployment.addClass(ConfigExecutor.class);
        deployment.addClass(ProviderConfig.class);
        deployment.addClass(Provider.class);
        deployment.addClass(DockerRuntimeConfig.class);
        deployment.addClass(DockerRuntime.class);
        deployment.addClass(RuntimeBuilder.class);
        deployment.addClass(DockerRuntimeExecExecutor.class);
        deployment.addClass(RuntimeDestroyer.class);
        deployment.addClass(DockerAccessInterface.class);
        deployment.addClass(DockerAccessInterfaceImpl.class);
        deployment.addClass(Disposable.class);
        deployment.addClass(DockerException.class);
        deployment.addClass(DockerRuntimeManager.class);
        deployment.addClass(RuntimeManager.class);
        deployment.addClass(Config.class);
        deployment.addClass(ProviderConfig.class);
        deployment.addClass(DockerProviderConfig.class);
        deployment.addClass(DockerProvider.class);
        deployment.addClass(FunctionConfigExecutor.class);
        deployment.addClass(BiFunctionConfigExecutor.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(ProviderBuilder.class);
        deployment.addClass(ProviderDestroyer.class);
        deployment.addClass(ProviderId.class);
        deployment.addClass(GitConfigExecutor.class);
        deployment.addClass(MavenProjectConfig.class);
        deployment.addClass(MavenProjectConfigExecutor.class);
        deployment.addClass(Project.class);
        deployment.addClass(Source.class);
        deployment.addClass(ProjectConfig.class);
        deployment.addClass(BuildConfig.class);
        deployment.addClass(MavenBuildConfig.class);
        deployment.addClass(MavenBuildConfigExecutor.class);
        deployment.addClass(MavenBuildExecConfigExecutor.class);
        deployment.addClass(DockerBuildConfigExecutor.class);
        deployment.addClass(DockerProviderConfigExecutor.class);
        deployment.addClass(DockerProvisioningConfigExecutor.class);
        deployment.addClass(MockPipelineEventListener.class);
        deployment.addClass(PipelineExecutorTaskManagerImpl.class);
        deployment.addClass(InMemoryPipelineExecutorRegistry.class);
        deployment.addClass(MockSystemPipelines.class);
        deployment.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return deployment;
    }

    @Before
    public void setUp() throws IOException {
        this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    public void testAPI() {
        ProviderTypeList allProviderTypes = this.runtimeService.getProviderTypes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)2L, (long)allProviderTypes.getItems().size());
        DockerProviderConfig dockerProviderConfig = new DockerProviderConfig(){};
        this.runtimeService.registerProvider((ProviderConfig)dockerProviderConfig);
        ProviderList allProviders = this.runtimeService.getProviders(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allProviders.getItems().size());
        Provider p = (Provider)allProviders.getItems().get(0);
        Assert.assertTrue((boolean)(p instanceof DockerProvider));
        int systemPipelines = 2;
        PipelineConfigsList allPipelineConfigs = this.pipelineService.getPipelineConfigs(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertNotNull((Object)allPipelineConfigs);
        Assert.assertEquals((long)systemPipelines, (long)allPipelineConfigs.getItems().size());
        ArrayList<Object> configs = new ArrayList<Object>();
        configs.add(new GitConfigImpl());
        configs.add(new MavenProjectConfigImpl());
        configs.add(new MavenBuildConfigImpl());
        configs.add(new DockerBuildConfigImpl());
        configs.add(new MavenBuildExecConfigImpl());
        configs.add(new DockerProviderConfigImpl());
        configs.add(new ContextAwareDockerProvisioningConfig());
        configs.add(new ContextAwareDockerRuntimeExecConfig());
        this.pipelineService.newPipeline((PipelineConfig)new PipelineConfigImpl("mypipe", configs));
        this.pipelineService.newPipeline((PipelineConfig)new PipelineConfigImpl("wildlfyPipe", configs), (ProviderType)WildflyProviderType.instance());
        this.pipelineService.newPipeline((PipelineConfig)new PipelineConfigImpl("dockerPipe", configs), (ProviderType)DockerProviderType.instance());
        allPipelineConfigs = this.pipelineService.getPipelineConfigs(Integer.valueOf(0), Integer.valueOf(10), "", true);
        int createdPipelines = 3;
        int totalPipelines = systemPipelines + createdPipelines;
        Assert.assertEquals((long)totalPipelines, (long)allPipelineConfigs.getItems().size());
        PipelineConfigsList wildflyConfigs = this.pipelineService.getPipelineConfigs(WildflyProviderType.instance().getProviderTypeName(), WildflyProviderType.instance().getVersion(), Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)2L, (long)wildflyConfigs.getItems().size());
        List wildflyPipelineNames = this.pipelineService.getPipelineNames(WildflyProviderType.instance().getProviderTypeName(), WildflyProviderType.instance().getVersion(), Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)2L, (long)wildflyPipelineNames.size());
        Assert.assertTrue((boolean)wildflyPipelineNames.contains("wildlfyPipe"));
        Assert.assertTrue((boolean)wildflyPipelineNames.contains("system-pipeline1"));
        PipelineConfigsList dockerConfigs = this.pipelineService.getPipelineConfigs(DockerProviderType.instance().getProviderTypeName(), DockerProviderType.instance().getVersion(), Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)dockerConfigs.getItems().size());
        List dockerPipelineNames = this.pipelineService.getPipelineNames(DockerProviderType.instance().getProviderTypeName(), DockerProviderType.instance().getVersion(), Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)dockerPipelineNames.size());
        Assert.assertTrue((boolean)dockerPipelineNames.contains("dockerPipe"));
        Input input = new Input();
        input.put((Object)"provider-name", (Object)"local");
        input.put((Object)"repo-name", (Object)"drools-workshop");
        input.put((Object)"create-repo", (Object)"true");
        input.put((Object)"branch", (Object)"master");
        input.put((Object)"out-dir", (Object)this.tempPath.getAbsolutePath());
        input.put((Object)"origin", (Object)"https://github.com/kiegroup/drools-workshop");
        input.put((Object)"project-dir", (Object)"drools-webapp-example");
        String pipelineExecutionId = this.pipelineService.runPipeline("mypipe", input, false);
        RuntimeQueryResultItemList itemList = this.runtimeService.executeQuery(RuntimeQueryBuilder.newInstance().withPipelineExecutionId(pipelineExecutionId).build());
        Assert.assertEquals((long)1L, (long)itemList.getItems().size());
        Assert.assertEquals((Object)pipelineExecutionId, (Object)((RuntimeQueryResultItem)itemList.getItems().get(0)).getPipelineExecutionId());
        this.pipelineService.deletePipelineExecution(pipelineExecutionId);
        itemList = this.runtimeService.executeQuery(RuntimeQueryBuilder.newInstance().withPipelineExecutionId(pipelineExecutionId).build());
        Assert.assertEquals((long)1L, (long)itemList.getItems().size());
        Assert.assertNull((Object)((RuntimeQueryResultItem)itemList.getItems().get(0)).getPipelineExecutionId());
        RuntimeList allRuntimes = this.runtimeService.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.getItems().size());
        this.runtimeService.destroyRuntime(((Runtime)allRuntimes.getItems().get(0)).getId(), true);
        allRuntimes = this.runtimeService.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)0L, (long)allRuntimes.getItems().size());
        Assert.assertEquals((long)18L, (long)this.listener.getEvents().size());
        pipelineExecutionId = this.pipelineService.runPipeline("mypipe", input, true);
        this.pipelineService.stopPipelineExecution(pipelineExecutionId);
        itemList = this.runtimeService.executeQuery(RuntimeQueryBuilder.newInstance().withPipelineExecutionId(pipelineExecutionId).build());
        Assert.assertEquals((long)1L, (long)itemList.getItems().size());
        Assert.assertEquals((Object)pipelineExecutionId, (Object)((RuntimeQueryResultItem)itemList.getItems().get(0)).getPipelineExecutionId());
        Assert.assertEquals((Object)PipelineExecutorTask.Status.STOPPED.name(), (Object)((RuntimeQueryResultItem)itemList.getItems().get(0)).getPipelineStatus());
    }
}

