/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest.tests;

import com.spotify.docker.client.DockerException;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.docker.access.DockerAccessInterface;
import org.guvnor.ala.docker.access.impl.DockerAccessInterfaceImpl;
import org.guvnor.ala.docker.config.DockerProviderConfig;
import org.guvnor.ala.docker.config.DockerRuntimeConfig;
import org.guvnor.ala.docker.executor.DockerProviderConfigExecutor;
import org.guvnor.ala.docker.executor.DockerRuntimeExecExecutor;
import org.guvnor.ala.docker.model.DockerProvider;
import org.guvnor.ala.docker.model.DockerProviderType;
import org.guvnor.ala.docker.model.DockerRuntime;
import org.guvnor.ala.docker.service.DockerRuntimeManager;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImpl;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineExecutorRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryPipelineRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.runtime.RuntimeBuilder;
import org.guvnor.ala.runtime.RuntimeDestroyer;
import org.guvnor.ala.runtime.RuntimeManager;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderBuilder;
import org.guvnor.ala.runtime.providers.ProviderDestroyer;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.RuntimeQuery;
import org.guvnor.ala.services.api.RuntimeQueryBuilder;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.api.itemlist.RuntimeQueryResultItemList;
import org.guvnor.ala.services.rest.RestRuntimeProvisioningServiceImpl;
import org.guvnor.ala.services.rest.factories.ProviderFactory;
import org.guvnor.ala.services.rest.factories.RuntimeFactory;
import org.guvnor.ala.services.rest.factories.RuntimeManagerFactory;
import org.guvnor.ala.wildfly.executor.WildflyProviderConfigExecutor;
import org.guvnor.ala.wildfly.model.WildflyProviderType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.commons.lifecycle.Disposable;

@RunWith(value=Arquillian.class)
public class RestRuntimeProvisioningImplTest {
    @Inject
    private RuntimeProvisioningService runtimeService;

    @Deployment
    public static Archive createDeployment() throws Exception {
        JavaArchive deployment = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        deployment.addClass(DockerProviderConfigExecutor.class);
        deployment.addClass(WildflyProviderConfigExecutor.class);
        deployment.addClass(RestRuntimeProvisioningServiceImpl.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(InMemoryRuntimeRegistry.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(ProviderFactory.class);
        deployment.addClass(RuntimeFactory.class);
        deployment.addClass(RuntimeManagerFactory.class);
        deployment.addClass(DockerProviderType.class);
        deployment.addClass(DockerProviderConfig.class);
        deployment.addClass(DockerProvider.class);
        deployment.addClass(WildflyProviderType.class);
        deployment.addClass(ProviderBuilder.class);
        deployment.addClass(ProviderType.class);
        deployment.addClass(FunctionConfigExecutor.class);
        deployment.addClass(ConfigExecutor.class);
        deployment.addClass(ProviderConfig.class);
        deployment.addClass(Provider.class);
        deployment.addClass(DockerRuntimeConfig.class);
        deployment.addClass(DockerRuntime.class);
        deployment.addClass(RuntimeBuilder.class);
        deployment.addClass(DockerRuntimeExecExecutor.class);
        deployment.addClass(RuntimeDestroyer.class);
        deployment.addClass(DockerAccessInterface.class);
        deployment.addClass(DockerAccessInterfaceImpl.class);
        deployment.addClass(Disposable.class);
        deployment.addClass(DockerException.class);
        deployment.addClass(DockerRuntimeManager.class);
        deployment.addClass(RuntimeManager.class);
        deployment.addClass(Config.class);
        deployment.addClass(ProviderConfig.class);
        deployment.addClass(DockerProviderConfig.class);
        deployment.addClass(DockerProvider.class);
        deployment.addClass(FunctionConfigExecutor.class);
        deployment.addClass(RuntimeRegistry.class);
        deployment.addClass(ProviderBuilder.class);
        deployment.addClass(ProviderDestroyer.class);
        deployment.addClass(ProviderId.class);
        deployment.addClass(PipelineExecutorTaskManagerImpl.class);
        deployment.addClass(InMemoryPipelineExecutorRegistry.class);
        deployment.addClass(InMemoryPipelineRegistry.class);
        deployment.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return deployment;
    }

    @Test
    public void testAPI() {
        ProviderTypeList allProviderTypes = this.runtimeService.getProviderTypes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)2L, (long)allProviderTypes.getItems().size());
        DockerProviderConfig dockerProviderConfig = new DockerProviderConfig(){};
        this.runtimeService.registerProvider((ProviderConfig)dockerProviderConfig);
        ProviderList allProviders = this.runtimeService.getProviders(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allProviders.getItems().size());
        final Provider p = (Provider)allProviders.getItems().get(0);
        Assert.assertTrue((boolean)(p instanceof DockerProvider));
        Assert.assertNotNull((Object)p.getId());
        Assert.assertNotNull((Object)p.getProviderType());
        Assert.assertNotNull((Object)p.getConfig());
        DockerRuntimeConfig dockerRuntimeConfiguration = new DockerRuntimeConfig(){

            public String getImage() {
                return "kitematic/hello-world-nginx";
            }

            public String getPort() {
                return "8080";
            }

            public boolean isPull() {
                return true;
            }

            public ProviderId getProviderId() {
                return p;
            }
        };
        String newRuntime = this.runtimeService.newRuntime((RuntimeConfig)dockerRuntimeConfiguration);
        Assert.assertNotNull((Object)newRuntime);
        RuntimeList allRuntimes = this.runtimeService.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.getItems().size());
        RuntimeQuery query = RuntimeQueryBuilder.newInstance().withProviderId(p.getId()).build();
        RuntimeQueryResultItemList queryResult = this.runtimeService.executeQuery(query);
        Assert.assertEquals((long)1L, (long)queryResult.getItems().size());
        Assert.assertEquals((Object)"RUNNING", (Object)((RuntimeQueryResultItem)queryResult.getItems().get(0)).getRuntimeStatus());
        this.runtimeService.destroyRuntime(newRuntime, true);
        allRuntimes = this.runtimeService.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)0L, (long)allRuntimes.getItems().size());
    }
}

