/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.marshalling;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.guvnor.ala.marshalling.Marshaller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseMarshallerTest<T> {
    protected Marshaller<T> marshaller;

    @Before
    public void setUp() {
        this.marshaller = this.createMarshaller();
    }

    public abstract Marshaller<T> createMarshaller();

    public abstract Class<T> getType();

    public abstract T getValue();

    public String getMarshallerOutput() throws Exception {
        return this.readResource(".marshallerOutput");
    }

    public String getMarshalledValue() throws Exception {
        return this.readResource(".marshalledValue");
    }

    public String readResource(String extension) throws Exception {
        URL resource = this.getClass().getResource(this.getType().getSimpleName() + extension);
        if (resource == null) {
            throw new Exception("No resource was found for: " + this.getType().getCanonicalName() + extension);
        }
        return new String(Files.readAllBytes(Paths.get(resource.toURI())));
    }

    @Test
    public void testGetClass() {
        Assert.assertEquals(this.getType(), (Object)this.marshaller.getType());
    }

    @Test
    public void testMarshall() throws Exception {
        String marshalledValue = this.marshaller.marshal(this.getValue());
        Assert.assertEquals((Object)this.getMarshallerOutput(), (Object)marshalledValue);
    }

    @Test
    public void testUnMarshall() throws Exception {
        Object result = this.marshaller.unmarshal(this.getMarshalledValue());
        Assert.assertEquals(this.getValue(), (Object)result);
    }
}

