/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.util;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class PopupHelperTest {
    private static final String TITLE = "TITLE";
    private static final String MESSAGE = "MESSAGE";
    private PopupHelper popupHelper;
    @Mock
    private YesNoCancelPopup yesNoCancelPopup;

    @Before
    public void setup() {
        this.popupHelper = (PopupHelper)Mockito.spy((Object)new PopupHelper(){

            protected YesNoCancelPopup newYesNoPopup(String title, String message, Command yesCommand, Command noCommand) {
                return PopupHelperTest.this.yesNoCancelPopup;
            }

            protected YesNoCancelPopup newNotificationPopup(String title, String message) {
                return PopupHelperTest.this.yesNoCancelPopup;
            }
        });
    }

    @Test
    public void testShowInformationPopup() {
        this.popupHelper.showInformationPopup(MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).newNotificationPopup(CommonConstants.INSTANCE.Information(), MESSAGE);
        this.verifyPopupWasShown(this.yesNoCancelPopup);
    }

    @Test
    public void testShowErrorPopup() {
        this.popupHelper.showErrorPopup(MESSAGE);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).newNotificationPopup(CommonConstants.INSTANCE.Error(), MESSAGE);
        this.verifyPopupWasShown(this.yesNoCancelPopup);
    }

    @Test
    public void testShowYesNoPopup() {
        Command yesCommand = (Command)Mockito.mock(Command.class);
        Command noCommand = (Command)Mockito.mock(Command.class);
        this.popupHelper.showYesNoPopup(TITLE, MESSAGE, yesCommand, noCommand);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).newYesNoPopup(TITLE, MESSAGE, yesCommand, noCommand);
        this.verifyPopupWasShown(this.yesNoCancelPopup);
    }

    @Test
    public void testGetPopupErrorCallback() {
        Message message = (Message)Mockito.mock(Message.class);
        this.popupHelper.getPopupErrorCallback().error((Object)message, (Throwable)new Exception(MESSAGE));
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup(MESSAGE);
        this.verifyPopupWasShown(this.yesNoCancelPopup);
    }

    private void verifyPopupWasShown(YesNoCancelPopup popup) {
        ((YesNoCancelPopup)Mockito.verify((Object)popup, (VerificationMode)Mockito.times((int)1))).setClosable(false);
        ((YesNoCancelPopup)Mockito.verify((Object)popup, (VerificationMode)Mockito.times((int)1))).clearScrollHeight();
        ((YesNoCancelPopup)Mockito.verify((Object)popup, (VerificationMode)Mockito.times((int)1))).show();
    }
}

