/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.project;

import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.ui.ProvisioningManagementTestCommons;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.project.GAVConfigurationChangeEvent;
import org.guvnor.ala.ui.client.wizard.project.GAVConfigurationParamsPresenter;
import org.guvnor.ala.ui.client.wizard.project.artifact.ArtifactSelectorPresenter;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GAVConfigurationParamsPresenterTest {
    private static final String GROUP_ID_VALUE = "GROUP_ID_VALUE";
    private static final String ARTIFACT_ID_VALUE = "ARTIFACT_ID_VALUE";
    private static final String VERSION_VALUE = "VERSION_VALUE";
    private static final String TITLE = "TITLE";
    private static final String JAR_PATH = "JAR_PATH";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Mock
    private GAVConfigurationParamsPresenter.View view;
    @Mock
    private ArtifactSelectorPresenter artifactSelector;
    @Mock
    private ArtifactSelectorPresenter.View artifactSelectorView;
    @Mock
    private TranslationService translationService;
    @Mock
    private PopupHelper popupHelper;
    private CallerMock<M2RepoService> m2RepoServiceCaller;
    @Mock
    private M2RepoService m2RepoService;
    @Mock
    private EventSourceMock<GAVConfigurationChangeEvent> gavConfigurationChangeEvent;
    private GAVConfigurationParamsPresenter presenter;

    @Before
    public void setUp() {
        Mockito.when((Object)this.artifactSelector.getView()).thenReturn((Object)this.artifactSelectorView);
        this.m2RepoServiceCaller = (CallerMock)Mockito.spy((Object)new CallerMock((Object)this.m2RepoService));
        this.presenter = (GAVConfigurationParamsPresenter)Mockito.spy((Object)new GAVConfigurationParamsPresenter(this.view, this.artifactSelector, this.translationService, this.popupHelper, this.m2RepoServiceCaller, this.gavConfigurationChangeEvent));
        this.presenter.init();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ArtifactSelectorPresenter)Mockito.verify((Object)this.artifactSelector, (VerificationMode)Mockito.times((int)1))).setArtifactSelectHandler((ArtifactSelectorPresenter.ArtifactSelectHandler)Matchers.any());
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactSelectorPresenter((IsElement)this.artifactSelectorView);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testBuildParams() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        Map result = this.presenter.buildParams();
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        expectedParams.put("group-id", GROUP_ID_VALUE);
        expectedParams.put("artifact-id", ARTIFACT_ID_VALUE);
        expectedParams.put("version", VERSION_VALUE);
        Assert.assertEquals(expectedParams, (Object)result);
    }

    @Test
    public void testInitialize() {
        this.presenter.initialise();
        ((ArtifactSelectorPresenter)Mockito.verify((Object)this.artifactSelector, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testPrepareView() {
        this.presenter.prepareView();
        ((ArtifactSelectorPresenter)Mockito.verify((Object)this.artifactSelector, (VerificationMode)Mockito.times((int)1))).refresh();
    }

    @Test
    public void testClear() {
        this.prepareClearView();
        this.presenter.clear();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((EventSourceMock)Mockito.verify(this.gavConfigurationChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new GAVConfigurationChangeEvent());
    }

    @Test
    public void testIsComplete() {
        this.prepareClearView();
        this.presenter.clear();
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testGetWizardTitle() {
        Mockito.when((Object)this.view.getWizardTitle()).thenReturn((Object)TITLE);
        Assert.assertEquals((Object)TITLE, (Object)this.presenter.getWizardTitle());
    }

    @Test
    public void testOnArtifactSelectedSuccessful() {
        GAV gav = new GAV(GROUP_ID_VALUE, ARTIFACT_ID_VALUE, VERSION_VALUE);
        Mockito.when((Object)this.m2RepoService.loadGAVFromJar(JAR_PATH)).thenReturn((Object)gav);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        this.presenter.onArtifactSelected(JAR_PATH);
        ((M2RepoService)Mockito.verify((Object)this.m2RepoService, (VerificationMode)Mockito.times((int)1))).loadGAVFromJar(JAR_PATH);
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupId(GROUP_ID_VALUE);
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId(ARTIFACT_ID_VALUE);
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersion(VERSION_VALUE);
        ((EventSourceMock)Mockito.verify(this.gavConfigurationChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new GAVConfigurationChangeEvent(gav));
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).fireChangeHandlers();
    }

    @Test
    public void testOnArtifactSelectedFailed() {
        this.prepareClearView();
        Mockito.when((Object)this.translationService.format("GAVConfigurationParamsPresenter.LoadGAVErrorMessage", new Object[]{"SERVICE_CALLER_EXCEPTION_MESSAGE"})).thenReturn((Object)ERROR_MESSAGE);
        ProvisioningManagementTestCommons.prepareServiceCallerError((Object)this.m2RepoService, this.m2RepoServiceCaller);
        this.presenter.onArtifactSelected(JAR_PATH);
        ((PopupHelper)Mockito.verify((Object)this.popupHelper, (VerificationMode)Mockito.times((int)1))).showErrorPopup(ERROR_MESSAGE);
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupId("");
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactId("");
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersion("");
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).fireChangeHandlers();
        ((EventSourceMock)Mockito.verify(this.gavConfigurationChangeEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new GAVConfigurationChangeEvent());
    }

    @Test
    public void testOnGroupIdChangedValid() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)GROUP_ID_VALUE);
        this.presenter.onGroupIdChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupIdStatus(FormStatus.VALID);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnGroupIdChangedInValid() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)"");
        this.presenter.onGroupIdChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupIdStatus(FormStatus.ERROR);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnArtifactIdChangedValid() {
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)ARTIFACT_ID_VALUE);
        this.presenter.onArtifactIdChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactIdStatus(FormStatus.VALID);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnArtifactIdChangedInValid() {
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)"");
        this.presenter.onArtifactIdChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactIdStatus(FormStatus.ERROR);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnVersionChangedValid() {
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VERSION_VALUE);
        this.presenter.onVersionChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersionStatus(FormStatus.VALID);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    @Test
    public void testOnVersionChangedInValid() {
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)"");
        this.presenter.onVersionChange();
        ((GAVConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersionStatus(FormStatus.ERROR);
        ((GAVConfigurationParamsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    private void prepareClearView() {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)"");
    }
}

