/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.providertype.item;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.ClientProviderHandlerRegistry;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.wizard.providertype.item.ProviderTypeItemPresenter;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProviderTypeItemPresenterTest {
    @Mock
    private ProviderTypeItemPresenter.View view;
    @Mock
    private ClientProviderHandlerRegistry handlerRegistry;
    @Mock
    private ClientProviderHandler providerHandler;
    private ProviderTypeItemPresenter presenter;
    private ProviderType providerType;

    @Before
    public void setUp() {
        this.providerType = new ProviderType(new ProviderTypeKey("PROVIDER_ID", "PROVIDER_VERSION"), "PROVIDER_NAME");
        Mockito.when((Object)this.handlerRegistry.getProviderHandler((ProviderTypeKey)this.providerType.getKey())).thenReturn((Object)this.providerHandler);
        Mockito.when((Object)this.providerHandler.getProviderTypeImageURL()).thenReturn((Object)"IMAGE_URL");
        this.presenter = new ProviderTypeItemPresenter(this.view, this.handlerRegistry);
        this.presenter.init();
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testSetupEnabled() {
        this.presenter.setup(this.providerType, ProviderTypeStatus.ENABLED);
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
        this.verifyCommons();
    }

    @Test
    public void testSetupDisabled() {
        this.presenter.setup(this.providerType, ProviderTypeStatus.DISABLED);
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).disable();
        this.verifyCommons();
    }

    @Test
    public void testGetProviderType() {
        this.presenter.setup(this.providerType, (ProviderTypeStatus)Mockito.mock(ProviderTypeStatus.class));
        Assert.assertEquals((Object)this.providerType, (Object)this.presenter.getProviderType());
    }

    @Test
    public void testIsSelected() {
        Mockito.when((Object)this.view.isSelected()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.presenter.isSelected());
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).isSelected();
    }

    @Test
    public void testNotIsSelected() {
        Mockito.when((Object)this.view.isSelected()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.isSelected());
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).isSelected();
    }

    @Test
    public void testContentChange() {
        ContentChangeHandler changeHandler = (ContentChangeHandler)Mockito.mock(ContentChangeHandler.class);
        this.presenter.addContentChangeHandler(changeHandler);
        this.presenter.fireChangeHandlers();
        ((ContentChangeHandler)Mockito.verify((Object)changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }

    private void verifyCommons() {
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProviderTypeName("PROVIDER_NAME PROVIDER_VERSION");
        ((ProviderTypeItemPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setImage("IMAGE_URL");
        ((ClientProviderHandlerRegistry)Mockito.verify((Object)this.handlerRegistry, (VerificationMode)Mockito.times((int)1))).getProviderHandler((ProviderTypeKey)this.providerType.getKey());
        ((ClientProviderHandler)Mockito.verify((Object)this.providerHandler, (VerificationMode)Mockito.times((int)1))).getProviderTypeImageURL();
    }
}

