/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.source;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.guvnor.ala.ui.client.util.ContentChangeHandler;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.source.SourceConfigurationParamsPresenter;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SourceConfigurationParamsPresenterTest {
    private static final int ELEMENTS_SIZE = 5;
    private static final String SOME_VALUE = "SOME_VALUE";
    private static final String RUNTIME_NAME = "RUNTIME_NAME";
    private static final String OU = "OU";
    private static final String REPOSITORY = "REPOSITORY";
    private static final String BRANCH = "BRANCH";
    private static final String PROJECT = "PROJECT";
    @Mock
    private SourceConfigurationParamsPresenter.View view;
    @Mock
    private SourceService sourceService;
    private Caller<SourceService> sourceServiceCaller;
    @Mock
    private ContentChangeHandler changeHandler;
    private SourceConfigurationParamsPresenter presenter;
    private List<String> ous;
    private List<String> repositories;
    private List<String> branches;
    private List<Project> projects;

    @Before
    public void setUp() {
        this.ous = this.createOUs();
        this.repositories = this.createRepositories();
        this.branches = this.createBranches();
        this.projects = this.createProjects();
        this.sourceServiceCaller = (Caller)Mockito.spy((Object)new CallerMock((Object)this.sourceService));
        this.presenter = new SourceConfigurationParamsPresenter(this.view, this.sourceServiceCaller);
        this.presenter.addContentChangeHandler(this.changeHandler);
        this.presenter.init();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testInitialize() {
        Mockito.when((Object)this.sourceService.getOrganizationUnits()).thenReturn(this.ous);
        this.presenter.initialise();
        this.ous.forEach(ou -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addOrganizationUnit(ou));
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearOrganizationUnits();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearRepositories();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearProjects();
    }

    @Test
    public void testIsComplete() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)"");
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)"");
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)SOME_VALUE);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        this.presenter.isComplete(Assert::assertFalse);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getProjects(REPOSITORY, BRANCH)).thenReturn(this.projects);
        this.presenter.onBranchChange();
        int selectedProject = 1;
        String projectName = this.projects.get(selectedProject).getProjectName();
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)projectName);
        this.presenter.isComplete(Assert::assertTrue);
    }

    @Test
    public void testBuildParams() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getProjects(REPOSITORY, BRANCH)).thenReturn(this.projects);
        this.presenter.onBranchChange();
        int selectedProject = 2;
        String projectName = this.projects.get(selectedProject).getProjectName();
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)projectName);
        Map params = this.presenter.buildParams();
        Assert.assertEquals((Object)RUNTIME_NAME, params.get("runtime-name"));
        Assert.assertEquals((Object)REPOSITORY, params.get("repo-name"));
        Assert.assertEquals((Object)BRANCH, params.get("branch"));
        Assert.assertEquals((Object)projectName, params.get("project-dir"));
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testDisable() {
        this.presenter.disable();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testOnRuntimeChangeValid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)RUNTIME_NAME);
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.VALID);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRuntimeChangeInvalid() {
        Mockito.when((Object)this.view.getRuntimeName()).thenReturn((Object)"");
        this.presenter.onRuntimeNameChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRuntimeStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnOrganizationalUnitChangeValid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)OU);
        Mockito.when((Object)this.sourceService.getRepositories(OU)).thenReturn(this.repositories);
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getOU();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearRepositories();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verityRepositoriesWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnOrganizationalUnitChangeInvalid() {
        Mockito.when((Object)this.view.getOU()).thenReturn((Object)"");
        this.presenter.onOrganizationalUnitChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setOUStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRepositoryChangeValid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.sourceService.getBranches(REPOSITORY)).thenReturn(this.branches);
        this.presenter.onRepositoryChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearBranches();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verifyBranchesWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnRepositoryChangeInvalid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)"");
        this.presenter.onRepositoryChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRepositoryStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnBranchChangeValid() {
        Mockito.when((Object)this.view.getRepository()).thenReturn((Object)REPOSITORY);
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)BRANCH);
        Mockito.when((Object)this.sourceService.getProjects(REPOSITORY, BRANCH)).thenReturn(this.projects);
        this.presenter.onBranchChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.VALID);
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearProjects();
        this.verifyProjectsWereLoaded();
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnBranchChangeInvalid() {
        Mockito.when((Object)this.view.getBranch()).thenReturn((Object)"");
        this.presenter.onBranchChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setBranchStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnProjectChangeValid() {
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)PROJECT);
        this.presenter.onProjectChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.VALID);
        this.verifyHandlerNotified();
    }

    @Test
    public void testOnProjectChangeInValid() {
        Mockito.when((Object)this.view.getProject()).thenReturn((Object)"");
        this.presenter.onProjectChange();
        ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectStatus(FormStatus.ERROR);
        this.verifyHandlerNotified();
    }

    private void verityRepositoriesWereLoaded() {
        this.repositories.forEach(repository -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addRepository(repository));
    }

    private void verifyBranchesWereLoaded() {
        this.branches.forEach(branch -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBranch(branch));
    }

    private void verifyProjectsWereLoaded() {
        this.projects.forEach(project -> ((SourceConfigurationParamsPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addProject(project.getProjectName()));
    }

    private List<String> createOUs() {
        return this.createValues(5, "OU.name.");
    }

    private List<String> createRepositories() {
        return this.createValues(5, "REPO.name.");
    }

    private List<String> createBranches() {
        return this.createValues(5, "Branch.name.");
    }

    private List<Project> createProjects() {
        ArrayList<Project> elements = new ArrayList<Project>();
        for (int i = 0; i < 5; ++i) {
            Project project = (Project)Mockito.mock(Project.class);
            Mockito.when((Object)project.getProjectName()).thenReturn((Object)("Project.name." + i));
            elements.add(project);
        }
        return elements;
    }

    private List<String> createValues(int size, String PREFIX) {
        ArrayList<String> elements = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            elements.add(PREFIX + i);
        }
        return elements;
    }

    private void verifyHandlerNotified() {
        ((ContentChangeHandler)Mockito.verify((Object)this.changeHandler, (VerificationMode)Mockito.times((int)1))).onContentChange();
    }
}

