/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.project;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.PopupHelper;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.client.wizard.pipeline.params.PipelineParamsForm;
import org.guvnor.ala.ui.client.wizard.project.GAVConfigurationChangeEvent;
import org.guvnor.ala.ui.client.wizard.project.artifact.ArtifactSelectorPresenter;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@ApplicationScoped
public class GAVConfigurationParamsPresenter
extends AbstractHasContentChangeHandlers
implements PipelineParamsForm {
    public static final String GROUP_ID = "group-id";
    public static final String ARTIFACT_ID = "artifact-id";
    public static final String VERSION = "version";
    private final View view;
    private final ArtifactSelectorPresenter artifactSelector;
    private PopupHelper popupHelper;
    private TranslationService translationService;
    private final Caller<M2RepoService> m2RepoService;
    private final Event<GAVConfigurationChangeEvent> gavConfigurationChangeEvent;

    @Inject
    public GAVConfigurationParamsPresenter(View view, ArtifactSelectorPresenter artifactSelector, TranslationService translationService, PopupHelper popupHelper, Caller<M2RepoService> m2RepoService, Event<GAVConfigurationChangeEvent> gavConfigurationChangeEvent) {
        this.view = view;
        this.artifactSelector = artifactSelector;
        this.popupHelper = popupHelper;
        this.translationService = translationService;
        this.m2RepoService = m2RepoService;
        this.gavConfigurationChangeEvent = gavConfigurationChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.artifactSelector.setArtifactSelectHandler(this::onArtifactSelected);
        this.view.setArtifactSelectorPresenter((IsElement)this.artifactSelector.getView());
    }

    @Override
    public IsElement getView() {
        return this.view;
    }

    @Override
    public Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GROUP_ID, this.getGroupId());
        params.put(ARTIFACT_ID, this.getArtifactId());
        params.put(VERSION, this.getVersion());
        return params;
    }

    @Override
    public void initialise() {
        this.artifactSelector.clear();
    }

    @Override
    public void prepareView() {
        this.artifactSelector.refresh();
    }

    @Override
    public void clear() {
        this.view.clear();
        this.fireGAVChangeEvent();
    }

    @Override
    public void isComplete(Callback<Boolean> callback) {
        boolean complete = this.isValid();
        callback.callback((Object)complete);
    }

    @Override
    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    private String getGroupId() {
        return UIUtil.trimOrGetEmpty(this.view.getGroupId());
    }

    private String getArtifactId() {
        return UIUtil.trimOrGetEmpty(this.view.getArtifactId());
    }

    private String getVersion() {
        return UIUtil.trimOrGetEmpty(this.view.getVersion());
    }

    protected void onArtifactSelected(String path) {
        ((M2RepoService)this.m2RepoService.call(this.getLoadGAVSuccessCallback(), this.getLoadGAVErrorCallback())).loadGAVFromJar(path);
    }

    protected void onGroupIdChange() {
        if (!this.getGroupId().isEmpty()) {
            this.view.setGroupIdStatus(FormStatus.VALID);
        } else {
            this.view.setGroupIdStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onArtifactIdChange() {
        if (!this.getArtifactId().isEmpty()) {
            this.view.setArtifactIdStatus(FormStatus.VALID);
        } else {
            this.view.setArtifactIdStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onVersionChange() {
        if (!this.getVersion().isEmpty()) {
            this.view.setVersionStatus(FormStatus.VALID);
        } else {
            this.view.setVersionStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    private boolean isValid() {
        return !this.getGroupId().isEmpty() && !this.getArtifactId().isEmpty() && !this.getVersion().isEmpty();
    }

    private RemoteCallback<GAV> getLoadGAVSuccessCallback() {
        return gav -> {
            this.view.setGroupId(gav.getGroupId());
            this.view.setArtifactId(gav.getArtifactId());
            this.view.setVersion(gav.getVersion());
            this.onContentChange();
        };
    }

    private ErrorCallback<Message> getLoadGAVErrorCallback() {
        return (message, throwable) -> {
            this.view.setGroupId("");
            this.view.setArtifactId("");
            this.view.setVersion("");
            this.popupHelper.showErrorPopup(this.translationService.format("GAVConfigurationParamsPresenter.LoadGAVErrorMessage", new Object[]{throwable.getMessage()}));
            this.onContentChange();
            return false;
        };
    }

    protected void onContentChange() {
        this.fireGAVChangeEvent();
        this.fireChangeHandlers();
    }

    private void fireGAVChangeEvent() {
        if (this.isValid()) {
            this.gavConfigurationChangeEvent.fire((Object)new GAVConfigurationChangeEvent(new GAV(this.getGroupId(), this.getArtifactId(), this.getVersion())));
        } else {
            this.gavConfigurationChangeEvent.fire((Object)new GAVConfigurationChangeEvent());
        }
    }

    public static interface View
    extends UberElement<GAVConfigurationParamsPresenter> {
        public String getWizardTitle();

        public String getGroupId();

        public void setGroupId(String var1);

        public String getArtifactId();

        public void setArtifactId(String var1);

        public String getVersion();

        public void setVersion(String var1);

        public void setArtifactSelectorPresenter(IsElement var1);

        public void clear();

        public void setGroupIdStatus(FormStatus var1);

        public void setArtifactIdStatus(FormStatus var1);

        public void setVersionStatus(FormStatus var1);
    }
}

