/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.client.wizard.pipeline.select.item;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.ala.ui.client.wizard.pipeline.select.item.PipelineItemPresenter;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.common.client.dom.Window;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class PipelineItemView
implements IsElement,
PipelineItemPresenter.View {
    @Inject
    @DataField(value="accented-area")
    private Div accentedArea;
    @Inject
    @Named(value="h2")
    @DataField(value="type-name")
    private Heading typeName;
    @Inject
    @DataField
    private Div body;
    @DataField
    private HTMLElement image = Window.getDocument().createElement("i");
    private PipelineItemPresenter presenter;

    public void init(PipelineItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setPipelineName(String name) {
        this.typeName.setTextContent(name);
    }

    @EventHandler(value={"image"})
    public void onClick(@ForEvent(value={"click"}) Event event) {
        if (!this.accentedArea.getClassList().contains("remove-option")) {
            this.accentedArea.getClassList().toggle("card-pf-accented");
            if (this.accentedArea.getClassList().contains("card-pf-accented")) {
                this.removeOpacity();
            } else {
                this.addOpacity();
            }
            this.presenter.onContentChange();
        }
    }

    @Override
    public boolean isSelected() {
        return this.accentedArea.getClassList().contains("card-pf-accented");
    }

    @Override
    public void unSelect() {
        this.accentedArea.getClassList().remove("card-pf-accented");
        this.addOpacity();
    }

    private void addOpacity() {
        this.body.getStyle().setProperty("opacity", "0.3");
    }

    private void removeOpacity() {
        this.body.getStyle().removeProperty("opacity");
    }
}

