/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.HostIp;
import org.arquillian.cube.requirement.ArquillianConditionalRunner;
import org.guvnor.ala.build.maven.config.MavenBuildConfig;
import org.guvnor.ala.build.maven.config.MavenBuildExecConfig;
import org.guvnor.ala.build.maven.config.MavenProjectConfig;
import org.guvnor.ala.build.maven.executor.MavenBuildConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenBuildExecConfigExecutor;
import org.guvnor.ala.build.maven.executor.MavenProjectConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.local.InMemoryBuildRegistry;
import org.guvnor.ala.registry.local.InMemoryRuntimeRegistry;
import org.guvnor.ala.registry.local.InMemorySourceRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.access.impl.WildflyAccessInterfaceImpl;
import org.guvnor.ala.wildfly.config.WildflyProviderConfig;
import org.guvnor.ala.wildfly.config.impl.ContextAwareWildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.executor.WildflyProviderConfigExecutor;
import org.guvnor.ala.wildfly.executor.WildflyRuntimeExecExecutor;
import org.guvnor.ala.wildfly.model.WildflyRuntime;
import org.guvnor.ala.wildfly.service.WildflyRuntimeManager;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ArquillianConditionalRunner.class)
public class WildflyExecutorTest {
    private static final String CONTAINER = "swarm";
    private File tempPath;
    @HostIp
    private String ip;
    @ArquillianResource
    private CubeController cc;

    @Before
    public void setUp() {
        try {
            this.tempPath = Files.createTempDirectory("xxx", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() {
        FileUtils.deleteQuietly((File)this.tempPath);
    }

    @Test
    @InSequence(value=1)
    public void shouldBeAbleToCreateAndStartTest() {
        this.cc.create(CONTAINER);
        this.cc.start(CONTAINER);
    }

    @Test
    @InSequence(value=2)
    public void testAPI() {
        InMemorySourceRegistry sourceRegistry = new InMemorySourceRegistry();
        InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
        InMemoryRuntimeRegistry runtimeRegistry = new InMemoryRuntimeRegistry();
        WildflyAccessInterfaceImpl wildflyAccessInterface = new WildflyAccessInterfaceImpl();
        Stage sourceConfig = StageUtil.config((String)"Git Source", s -> new GitConfig(){});
        Stage projectConfig = StageUtil.config((String)"Maven Project", s -> new MavenProjectConfig(){});
        Stage buildConfig = StageUtil.config((String)"Maven Build Config", s -> new MavenBuildConfig(){});
        Stage buildExec = StageUtil.config((String)"Maven Build", s -> new MavenBuildExecConfig(){});
        Stage providerConfig = StageUtil.config((String)"Wildfly Provider Config", s -> new WildflyProviderConfig(){});
        Stage runtimeExec = StageUtil.config((String)"Wildfly Runtime Exec", s -> new ContextAwareWildflyRuntimeExecConfig());
        Pipeline pipe = PipelineFactory.startFrom((Stage)sourceConfig).andThen(projectConfig).andThen(buildConfig).andThen(buildExec).andThen(providerConfig).andThen(runtimeExec).buildAs("my pipe");
        WildflyRuntimeExecExecutor wildflyRuntimeExecExecutor = new WildflyRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (WildflyAccessInterface)wildflyAccessInterface);
        PipelineExecutor executor = new PipelineExecutor(Arrays.asList(new GitConfigExecutor((SourceRegistry)sourceRegistry), new MavenProjectConfigExecutor((SourceRegistry)sourceRegistry), new MavenBuildConfigExecutor(), new MavenBuildExecConfigExecutor((BuildRegistry)buildRegistry), new WildflyProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), wildflyRuntimeExecExecutor));
        executor.execute(new Input(){
            {
                this.put("repo-name", "drools-workshop");
                this.put("branch", "master");
                this.put("out-dir", WildflyExecutorTest.this.tempPath.getAbsolutePath());
                this.put("origin", "https://github.com/salaboy/drools-workshop");
                this.put("project-dir", "drools-webapp-example");
                this.put("wildfly-user", "admin");
                this.put("wildfly-password", "Admin#70365");
                this.put("host", WildflyExecutorTest.this.ip);
                this.put("port", "8080");
                this.put("management-port", "9990");
            }
        }, pipe, System.out::println, new PipelineEventListener[0]);
        List allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        Runtime runtime = (Runtime)allRuntimes.get(0);
        Assert.assertTrue((boolean)(runtime instanceof WildflyRuntime));
        WildflyRuntime wildflyRuntime = (WildflyRuntime)runtime;
        WildflyRuntimeManager runtimeManager = new WildflyRuntimeManager((RuntimeRegistry)runtimeRegistry, (WildflyAccessInterface)wildflyAccessInterface);
        runtimeManager.start((RuntimeId)wildflyRuntime);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        Assert.assertTrue((boolean)(runtime instanceof WildflyRuntime));
        wildflyRuntime = (WildflyRuntime)runtime;
        Assert.assertEquals((Object)"Running", (Object)wildflyRuntime.getState().getState());
        runtimeManager.stop((RuntimeId)wildflyRuntime);
        allRuntimes = runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(10), "", true);
        Assert.assertEquals((long)1L, (long)allRuntimes.size());
        runtime = (Runtime)allRuntimes.get(0);
        Assert.assertTrue((boolean)(runtime instanceof WildflyRuntime));
        wildflyRuntime = (WildflyRuntime)runtime;
        Assert.assertEquals((Object)"Stopped", (Object)wildflyRuntime.getState().getState());
        wildflyRuntimeExecExecutor.destroy((RuntimeId)wildflyRuntime);
        wildflyAccessInterface.dispose();
    }

    @Test
    @InSequence(value=3)
    public void shouldBeAbleToStopAndDestroyTest() {
        this.cc.stop(CONTAINER);
        this.cc.destroy(CONTAINER);
    }
}

