/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.config.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.build.Project;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;

public class ContextAwareWildflyRuntimeExecConfig
implements ContextAware,
WildflyRuntimeExecConfig,
CloneableConfig<WildflyRuntimeExecConfig> {
    @JsonIgnore
    private Map<String, ?> context;
    private ProviderId providerId;
    private String warPath;
    private final Map<Project, RepositoryVisitor> projectVisitorMap = new HashMap<Project, RepositoryVisitor>();

    public ContextAwareWildflyRuntimeExecConfig() {
    }

    public ContextAwareWildflyRuntimeExecConfig(ProviderId providerId, String warPath) {
        this.providerId = providerId;
        this.warPath = warPath;
    }

    public void setContext(Map<String, ?> context) {
        this.context = context;
        MavenBinary binary = (MavenBinary)context.get("binary");
        String binaryPath = binary.getProject().getExpectedBinary();
        String projectPath = this.getRepositoryVisitor(binary.getProject()).getProjectFolder().getAbsolutePath();
        WildflyProvider provider = (WildflyProvider)context.get("wildfly-provider");
        this.providerId = provider;
        this.warPath = projectPath + "/target/" + binaryPath;
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    @Override
    public String getWarPath() {
        return this.warPath;
    }

    private RepositoryVisitor getRepositoryVisitor(Project project) {
        RepositoryVisitor projectVisitor;
        if (this.projectVisitorMap.containsKey(project)) {
            projectVisitor = this.projectVisitorMap.get(project);
        } else {
            projectVisitor = new RepositoryVisitor(project);
            this.projectVisitorMap.put(project, projectVisitor);
        }
        return projectVisitor;
    }

    public WildflyRuntimeExecConfig asNewClone(WildflyRuntimeExecConfig origin) {
        return new ContextAwareWildflyRuntimeExecConfig(origin.getProviderId(), origin.getWarPath());
    }
}

