/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor.tests;

import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.access.WildflyClient;
import org.guvnor.ala.wildfly.access.impl.WildflyAccessInterfaceImpl;
import org.guvnor.ala.wildfly.model.WildflyProviderImpl;
import org.junit.Assert;
import org.junit.Test;

public class WildflyAccessInterfaceImplTest {
    private WildflyAccessInterfaceImpl accessInterface = new WildflyAccessInterfaceImpl();
    private static final String PROVIDER = "wildfly";

    @Test
    public void testWildflyClientNull() {
        WildflyClient client = this.accessInterface.getWildflyClient((ProviderId)new WildflyProviderImpl(PROVIDER, null, null, null, null, null));
        Assert.assertNotNull((Object)client);
        Assert.assertEquals((long)client.getPort(), (long)8080L);
        Assert.assertEquals((long)client.getManagementPort(), (long)9990L);
    }

    @Test
    public void testWildflyClient() {
        String hostId = "localhost";
        String port = "8081";
        String managementPort = "9991";
        String user = "admin";
        String password = "pass";
        WildflyClient client = this.accessInterface.getWildflyClient((ProviderId)new WildflyProviderImpl(PROVIDER, "localhost", "8081", "9991", "admin", "pass"));
        Assert.assertNotNull((Object)client);
        Assert.assertEquals((long)client.getPort(), (long)8081L);
        Assert.assertEquals((long)client.getManagementPort(), (long)9991L);
        Assert.assertEquals((Object)client.getHost(), (Object)"localhost");
        Assert.assertEquals((Object)client.getProviderName(), (Object)PROVIDER);
        Assert.assertEquals((Object)client.getUser(), (Object)"admin");
        Assert.assertEquals((Object)client.getPassword(), (Object)"pass");
    }
}

