/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.executor.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.appformer.maven.integration.embedder.MavenProjectLoader;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.HostIp;
import org.arquillian.cube.requirement.ArquillianConditionalRunner;
import org.guvnor.ala.build.maven.model.impl.MavenProjectImpl;
import org.guvnor.ala.build.maven.util.MavenBuildExecutor;
import org.guvnor.ala.build.maven.util.RepositoryVisitor;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.registry.local.InMemorySourceRegistry;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.GitHub;
import org.guvnor.ala.source.git.GitRepository;
import org.guvnor.ala.source.git.config.GitConfig;
import org.guvnor.ala.source.git.config.impl.GitConfigImpl;
import org.guvnor.ala.source.git.executor.GitConfigExecutor;
import org.guvnor.ala.wildfly.access.WildflyAppState;
import org.guvnor.ala.wildfly.access.WildflyClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=ArquillianConditionalRunner.class)
public class WildflyRuntimeTest {
    private static final String CONTAINER = "swarm";
    private static File tempPath;
    @HostIp
    private String ip;
    @ArquillianResource
    private CubeController cc;

    @BeforeClass
    public static void setUp() {
        try {
            tempPath = Files.createTempDirectory("ooo", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void tearDown() {
        FileUtils.deleteQuietly((File)tempPath);
    }

    @Test
    @InSequence(value=1)
    public void shouldBeAbleToCreateAndStartTest() {
        this.cc.create(CONTAINER);
        this.cc.start(CONTAINER);
    }

    @Test
    @InSequence(value=2)
    public void waitForAppBuildTest() {
        GitHub gitHub = new GitHub();
        GitRepository repository = (GitRepository)gitHub.getRepository("salaboy/drools-workshop", (Map)new HashMap<String, String>(){
            {
                this.put("out-dir", tempPath.getAbsolutePath());
            }
        });
        Optional _source = new GitConfigExecutor((SourceRegistry)new InMemorySourceRegistry()).apply((GitConfig)new GitConfigImpl(tempPath.getAbsolutePath(), "master", "https://github.com/salaboy/drools-workshop", "drools-workshop-build", "true"));
        Assert.assertTrue((boolean)_source.isPresent());
        Source source = (Source)_source.get();
        Assert.assertNotNull((Object)source);
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("package");
        Properties properties = new Properties();
        properties.setProperty("failIfNoTests", "false");
        Path projectRoot = source.getPath().resolve("drools-webapp-example");
        InputStream pomStream = org.uberfire.java.nio.file.Files.newInputStream((Path)projectRoot.resolve("pom.xml"), (OpenOption[])new OpenOption[0]);
        MavenProject project = MavenProjectLoader.parseMavenPom((InputStream)pomStream);
        RepositoryVisitor repositoryVisitor = new RepositoryVisitor(projectRoot, project.getName());
        String expectedBinary = project.getArtifact().getArtifactId() + "-" + project.getArtifact().getVersion() + "." + project.getArtifact().getType();
        MavenProjectImpl mavenProject = new MavenProjectImpl(project.getId(), project.getArtifact().getType(), project.getName(), expectedBinary, source.getPath(), source.getPath().resolve("drools-webapp-example"), source.getPath().resolve("target").resolve(expectedBinary).toAbsolutePath(), repositoryVisitor.getRoot().getAbsolutePath(), null);
        File pom = new File(mavenProject.getTempDir(), "pom.xml");
        MavenBuildExecutor.executeMaven((File)pom, (Properties)properties, (String[])goals.toArray(new String[0]));
        File file = new File(repositoryVisitor.getRoot().getAbsolutePath() + "/target/" + mavenProject.getExpectedBinary());
        WildflyClient wildflyClient = new WildflyClient("", "admin", "Admin#70365", this.ip, 8080, 9990);
        wildflyClient.deploy(file);
        String id = file.getName();
        WildflyAppState appState = wildflyClient.getAppState(id);
        Assert.assertNotNull((Object)appState);
        Assert.assertTrue((boolean)appState.getState().equals("Running"));
        wildflyClient.undeploy(id);
        appState = wildflyClient.getAppState(id);
        Assert.assertNotNull((Object)appState);
        Assert.assertTrue((boolean)appState.getState().equals("NA"));
        wildflyClient.deploy(file);
        appState = wildflyClient.getAppState(id);
        Assert.assertNotNull((Object)appState);
        Assert.assertTrue((boolean)appState.getState().equals("Running"));
    }

    @Test
    @InSequence(value=3)
    public void shouldBeAbleToStopAndDestroyTest() {
        this.cc.stop(CONTAINER);
        this.cc.destroy(CONTAINER);
    }
}

