/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.wildfly.config.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.guvnor.ala.build.maven.model.MavenBinary;
import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.wildfly.config.WildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.model.WildflyProvider;

public class ContextAwareWildflyRuntimeExecConfig
implements ContextAware,
WildflyRuntimeExecConfig,
CloneableConfig<WildflyRuntimeExecConfig> {
    @JsonIgnore
    private Map<String, ?> context;
    private String runtimeName;
    private ProviderId providerId;
    private String warPath;
    private String redeployStrategy;

    public ContextAwareWildflyRuntimeExecConfig() {
        this.warPath = WildflyRuntimeExecConfig.super.getWarPath();
        this.redeployStrategy = WildflyRuntimeExecConfig.super.getRedeployStrategy();
        this.runtimeName = WildflyRuntimeExecConfig.super.getRuntimeName();
    }

    public ContextAwareWildflyRuntimeExecConfig(String runtimeName, ProviderId providerId, String warPath, String redeployStrategy) {
        this.runtimeName = runtimeName;
        this.providerId = providerId;
        this.warPath = warPath;
        this.redeployStrategy = redeployStrategy;
    }

    public void setContext(Map<String, ?> context) {
        this.context = context;
        MavenBinary binary = (MavenBinary)context.get("binary");
        if (binary != null) {
            this.warPath = binary.getPath().toString();
        }
        WildflyProvider provider = (WildflyProvider)context.get("wildfly-provider");
        this.providerId = provider;
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    @Override
    public String getWarPath() {
        return this.warPath;
    }

    @Override
    public String getRedeployStrategy() {
        return this.redeployStrategy;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public WildflyRuntimeExecConfig asNewClone(WildflyRuntimeExecConfig origin) {
        return new ContextAwareWildflyRuntimeExecConfig(origin.getRuntimeName(), origin.getProviderId(), origin.getWarPath(), origin.getRedeployStrategy());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextAwareWildflyRuntimeExecConfig that = (ContextAwareWildflyRuntimeExecConfig)o;
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        if (this.runtimeName != null ? !this.runtimeName.equals(that.runtimeName) : that.runtimeName != null) {
            return false;
        }
        if (this.providerId != null ? !this.providerId.equals(that.providerId) : that.providerId != null) {
            return false;
        }
        if (this.warPath != null ? !this.warPath.equals(that.warPath) : that.warPath != null) {
            return false;
        }
        return this.redeployStrategy != null ? this.redeployStrategy.equals(that.redeployStrategy) : that.redeployStrategy == null;
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + (this.runtimeName != null ? this.runtimeName.hashCode() : 0);
        result = 31 * result + (this.providerId != null ? this.providerId.hashCode() : 0);
        result = 31 * result + (this.warPath != null ? this.warPath.hashCode() : 0);
        result = 31 * result + (this.redeployStrategy != null ? this.redeployStrategy.hashCode() : 0);
        return result;
    }
}

