/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.handlers;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.asset.management.backend.handlers.AssetMgmtStartWorkItemHandler;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.DataUtils;
import org.guvnor.asset.management.social.ProcessEndEvent;
import org.guvnor.asset.management.social.ProcessStartEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssetMgmtStartEndBaseWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetMgmtStartWorkItemHandler.class);

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String _ProcessName = (String)workItem.getParameter("ProcessName");
        String _Owner = (String)workItem.getParameter("Owner");
        String user = "system";
        String repositoryURI = null;
        BeanManager beanManager = null;
        RepositoryService repositoryService = null;
        Object repositoryInfo = null;
        if (this.isStart()) {
            logger.debug("Start assets management process: " + _ProcessName + "  " + new Date());
            System.out.println("Start assets management process: " + _ProcessName + "  " + new Date());
        } else {
            logger.debug("End assets management process: " + _ProcessName + "  " + new Date());
            System.out.println("End assets management process: " + _ProcessName + "  " + new Date());
        }
        try {
            beanManager = CDIUtils.lookUpBeanManager(null);
            repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
        }
        catch (Exception e) {
            logger.debug("BeanManager lookup error.", (Throwable)e);
        }
        if (beanManager != null && "ConfigureRepository".equals(_ProcessName)) {
            String _CB_RepositoryName = (String)workItem.getParameter("CB_RepositoryName");
            repositoryURI = DataUtils.readRepositoryURI(repositoryService, _CB_RepositoryName);
            if (this.isStart()) {
                ProcessStartEvent event = new ProcessStartEvent(_ProcessName, _CB_RepositoryName, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                beanManager.fireEvent((Object)event, new Annotation[0]);
            } else {
                ProcessEndEvent event = new ProcessEndEvent(_ProcessName, _CB_RepositoryName, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
        } else if (beanManager != null && "PromoteAssets".equals(_ProcessName)) {
            String _PA_GitRepositoryName = (String)workItem.getParameter("PA_GitRepositoryName");
            repositoryURI = DataUtils.readRepositoryURI(repositoryService, _PA_GitRepositoryName);
            if (this.isStart()) {
                ProcessStartEvent event = new ProcessStartEvent(_ProcessName, _PA_GitRepositoryName, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                beanManager.fireEvent((Object)event, new Annotation[0]);
            } else {
                ProcessEndEvent event = new ProcessEndEvent(_ProcessName, _PA_GitRepositoryName, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
        } else if (beanManager != null && "BuildProject".equals(_ProcessName)) {
            String _BP_ProjectURI = (String)workItem.getParameter("BP_ProjectURI");
            String _BP_BranchName = (String)workItem.getParameter("BP_BranchName");
            String _BP_Repository = null;
            String _BP_Project = null;
            if (_BP_ProjectURI != null && _BP_ProjectURI.indexOf("/") > 0) {
                _BP_Repository = _BP_ProjectURI.substring(0, _BP_ProjectURI.indexOf("/"));
                _BP_Project = _BP_ProjectURI.substring(_BP_ProjectURI.indexOf("/") + 1, _BP_ProjectURI.length());
                repositoryURI = DataUtils.readRepositoryURI(repositoryService, _BP_Repository);
            }
            if (this.isStart()) {
                ProcessStartEvent event = new ProcessStartEvent(_ProcessName, _BP_Repository, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                event.addParam("project", _BP_Project);
                event.addParam("branch", _BP_BranchName);
                beanManager.fireEvent((Object)event, new Annotation[0]);
            } else {
                String _BP_BuildOutcome = (String)workItem.getParameter("BP_BuildOutcome");
                List _BP_Errors = (List)workItem.getParameter("BP_Errors");
                List _BP_Warnings = (List)workItem.getParameter("BP_Warnings");
                List _BP_Infos = (List)workItem.getParameter("BP_Infos");
                String _BP_GAV = (String)workItem.getParameter("BP_GAV");
                String _BP_MavenDeployOutcome = (String)workItem.getParameter("BP_MavenDeployOutcome");
                String _BP_ExecServerURL = (String)workItem.getParameter("BP_ExecServerURL");
                String _BP_Username = (String)workItem.getParameter("BP_Username");
                Boolean _BP_DeployToRuntime = Boolean.TRUE.equals(workItem.getParameter("BP_DeployToRuntime"));
                Exception _BP_Exception = (Exception)workItem.getParameter("BP_Exception");
                ProcessEndEvent event = new ProcessEndEvent(_ProcessName, _BP_Repository, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                event.addParam("BP_BuildOutcome", _BP_BuildOutcome);
                event.addParam("BP_GAV", _BP_GAV);
                event.addParam("BP_MavenDeployOutcome", _BP_MavenDeployOutcome);
                event.addParam("BP_ExecServerURL", _BP_ExecServerURL);
                event.addParam("BP_Username", _BP_Username);
                event.addParam("BP_DeployToRuntime", _BP_DeployToRuntime.toString());
                event.addParam("project", _BP_Project);
                event.addParam("branch", _BP_BranchName);
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
        } else if (beanManager != null && "ReleaseProject".equals(_ProcessName)) {
            String _RP_ProjectURI = (String)workItem.getParameter("RP_ProjectURI");
            String _RP_ToReleaseVersion = (String)workItem.getParameter("RP_ToReleaseVersion");
            String _RP_Repository = _RP_ProjectURI != null && _RP_ProjectURI.indexOf("/") > 0 ? _RP_ProjectURI.substring(0, _RP_ProjectURI.indexOf("/")) : _RP_ProjectURI;
            repositoryURI = DataUtils.readRepositoryURI(repositoryService, _RP_Repository);
            if (this.isStart()) {
                ProcessStartEvent event = new ProcessStartEvent(_ProcessName, _RP_Repository, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                event.addParam("version", _RP_ToReleaseVersion);
                beanManager.fireEvent((Object)event, new Annotation[0]);
            } else {
                ProcessEndEvent event = new ProcessEndEvent(_ProcessName, _RP_Repository, repositoryURI, user, Long.valueOf(System.currentTimeMillis()));
                event.addParam("version", _RP_ToReleaseVersion);
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
        }
        if (manager != null) {
            manager.completeWorkItem(workItem.getId(), null);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected abstract boolean isStart();
}

