/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.asset.management.social.ProcessStartEvent;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

@ApplicationScoped
public class ProcessStartEventAdapter
implements SocialAdapter<ProcessStartEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<ProcessStartEvent> eventToIntercept() {
        return ProcessStartEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.PROCESS_START;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        ProcessStartEvent event = (ProcessStartEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.PROCESS_START.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias() != null ? event.getRepositoryAlias() : "<unknown>", event.getRootURI() != null ? event.getRootURI() : "<unknown>").withAdicionalInfo(new String[]{this.getAdditionalInfo(event.getProcessName(), event.getRepositoryAlias(), event.getParams())});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(String process, String repo, Map<String, String> params) {
        if ("ConfigureRepository".equals(process)) {
            return this.constants.configure_repository_start(repo);
        }
        if ("PromoteAssets".equals(process)) {
            return this.constants.promote_assets_start(repo);
        }
        if ("BuildProject".equals(process)) {
            return this.constants.build_project_start(params.get("project"), params.get("branch"), repo);
        }
        if ("ReleaseProject".equals(process)) {
            return this.constants.release_project_start(repo);
        }
        return "";
    }
}

