/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.DataUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.guvnor.asset.management.social.ProjectBuiltEvent;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.messageconsole.events.MessageUtils;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class BuildProjectCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(BuildProjectCommand.class);

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        try {
            ExecutionResults executionResults = new ExecutionResults();
            String buildOutcome = "UNKNOWN";
            String uri = (String)this.getParameter(ctx, "Uri");
            String branchToBuild = (String)this.getParameter(ctx, "BranchToBuild");
            String projectUri = "default://" + branchToBuild + "@" + uri;
            BeanManager beanManager = CDIUtils.lookUpBeanManager(ctx);
            logger.debug("BeanManager " + beanManager);
            BuildService buildService = CDIUtils.createBean(BuildService.class, beanManager, new Annotation[0]);
            logger.debug("BuildService " + buildService);
            IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
            logger.debug("IoService " + ioService);
            RepositoryService repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
            logger.debug("RepositoryService " + repositoryService);
            ProjectBuiltEvent event = this.getSocialEvent((String)ctx.getData("_ProcessName"), uri, branchToBuild, repositoryService);
            if (ioService != null) {
                Path projectPath = ioService.get(URI.create(projectUri));
                logger.debug("Project path is " + projectPath);
                ProjectService projectService = (ProjectService)CDIUtils.createBean(new TypeLiteral<ProjectService<?>>(){}.getType(), beanManager, new Annotation[0]);
                Project project = projectService.resolveProject(Paths.convert((Path)projectPath));
                if (project == null) {
                    throw new IllegalArgumentException("Unable to find project " + projectUri);
                }
                BuildResults results = buildService.build(project);
                if (logger.isDebugEnabled()) {
                    logger.debug("Errors " + results.getErrorMessages().size());
                    logger.debug("Warnings " + results.getWarningMessages().size());
                    logger.debug("Info " + results.getInformationMessages().size());
                }
                if (results.getErrorMessages().isEmpty()) {
                    buildOutcome = "SUCCESSFUL";
                } else {
                    buildOutcome = "FAILURE";
                    PublishBatchMessagesEvent publishMessage = new PublishBatchMessagesEvent();
                    publishMessage.setCleanExisting(true);
                    ArrayList<SystemMessage> messageList = new ArrayList<SystemMessage>();
                    for (BuildMessage message : results.getMessages()) {
                        event.addError(message.getText());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error " + message.getText());
                        }
                        messageList.add(MessageUtils.convert((BuildMessage)message));
                    }
                    publishMessage.setMessagesToPublish(messageList);
                    beanManager.fireEvent((Object)publishMessage, new Annotation[0]);
                }
                executionResults.setData("Errors", this.processMessages(results.getErrorMessages()));
                executionResults.setData("Warnings", this.processMessages(results.getWarningMessages()));
                executionResults.setData("Info", this.processMessages(results.getInformationMessages()));
                executionResults.setData("GAV", (Object)results.getGAV().toString());
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
            executionResults.setData("BuildOutcome", (Object)buildOutcome);
            return executionResults;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }

    private ProjectBuiltEvent getSocialEvent(String processName, String uriParam, String branchToBuild, RepositoryService repositoryService) {
        String repository = null;
        String projectName = null;
        String repositoryURI = null;
        if (uriParam != null && uriParam.indexOf("/") > 0) {
            repository = uriParam.substring(0, uriParam.indexOf("/"));
            projectName = uriParam.substring(uriParam.indexOf("/") + 1, uriParam.length());
            repositoryURI = DataUtils.readRepositoryURI(repositoryService, repository);
        }
        ProjectBuiltEvent event = new ProjectBuiltEvent(processName, repository, repositoryURI, "system", Long.valueOf(System.currentTimeMillis()));
        event.setBranchName(branchToBuild);
        event.setProjectName(projectName);
        return event;
    }

    protected List<String> processMessages(List<BuildMessage> messageList) {
        ArrayList<String> messages = new ArrayList<String>();
        if (messageList != null) {
            for (BuildMessage buildMessage : messageList) {
                messages.add(buildMessage.getText());
            }
        }
        return messages;
    }
}

