/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.util.HashMap;
import java.util.Set;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;

public class CompositeCommand
extends AbstractCommand {
    public ExecutionResults execute(CommandContext commandContext) throws Exception {
        try {
            String commands = (String)this.getParameter(commandContext, "Commands");
            ClassLoader cl = (ClassLoader)this.getParameter(commandContext, "ClassLoader");
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            String[] commandsList = commands.split(",");
            ExecutionResults results = new ExecutionResults();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (String cmd : commandsList) {
                Class<?> forName = Class.forName(cmd.trim(), true, cl);
                Command newInstance = (Command)forName.newInstance();
                ExecutionResults execute = newInstance.execute(commandContext);
                Set keySet = execute.keySet();
                for (String key : keySet) {
                    data.put(key, execute.getData(key));
                    commandContext.getData().put(key, execute.getData(key));
                }
            }
            results.setData(data);
            return results;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }
}

