/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.asset.management.social.AssetsPromotedEvent;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

public class AssetsPromotedEventAdapter
implements SocialAdapter<AssetsPromotedEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<AssetsPromotedEvent> eventToIntercept() {
        return AssetsPromotedEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.ASSETS_PROMOTED;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        AssetsPromotedEvent event = (AssetsPromotedEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.ASSETS_PROMOTED.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias() != null ? event.getRepositoryAlias() : "<unknown>", event.getRootURI() != null ? event.getRootURI() : "<unknown>").withAdicionalInfo(new String[]{this.getAdditionalInfo(event)});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(AssetsPromotedEvent event) {
        StringBuilder info = new StringBuilder();
        if (!event.hasErrors()) {
            info.append(this.constants.promote_assets_assets_promoted(event.getRepositoryAlias(), event.getSourceBranch(), event.getTargetBranch()));
            info.append("\n");
            List assets = event.getAssets();
            if (assets != null) {
                for (String asset : assets) {
                    info.append(asset + "\n");
                }
            }
        } else {
            info.append(this.constants.promote_assets_failed(event.getRepositoryAlias(), (String)event.getErrors().get(0)));
        }
        return info.toString();
    }
}

