/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.asset.management.backend.service.RepositoryStructureServiceImpl;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.m2repo.backend.server.GuvnorM2Repository;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryStructureServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private POMService pomService;
    @Mock
    private ProjectService<Project> projectService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private MetadataService metadataService;
    @Mock
    private GuvnorM2Repository m2service;
    @Mock
    private CommentedOptionFactory optionsFactory;
    private Event<RepositoryEnvironmentUpdatedEvent> repositoryUpdatedEvent = new EventSourceMock<RepositoryEnvironmentUpdatedEvent>(){

        public void fire(RepositoryEnvironmentUpdatedEvent event) {
        }
    };
    @Mock
    private ProjectRepositoryResolver repositoryResolver;
    private RepositoryStructureService service;

    @BeforeClass
    public static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @Before
    public void setup() {
        this.service = new RepositoryStructureServiceImpl(this.ioService, this.pomService, this.projectService, this.repositoryService, this.metadataService, this.m2service, this.optionsFactory, this.repositoryUpdatedEvent, this.repositoryResolver);
    }

    @Test
    public void testInitRepositoryStructure1() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn(Collections.emptySet());
        this.service.initRepositoryStructure(gav, repository, DeploymentMode.VALIDATED);
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)pomArgumentCaptor.capture());
        Assert.assertNotNull((Object)pomArgumentCaptor.getValue());
        Assert.assertEquals((Object)"groupId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getArtifactId());
        Assert.assertEquals((Object)"version", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getVersion());
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.times((int)1))).deployParentPom((GAV)Mockito.eq((Object)gav));
    }

    @Test
    public void testInitRepositoryStructure1ClashingGAV() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        try {
            this.service.initRepositoryStructure(gav, repository, DeploymentMode.VALIDATED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.never())).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)Mockito.any(POM.class));
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.never())).deployParentPom((GAV)Mockito.eq((Object)gav));
    }

    @Test
    public void testInitRepositoryStructure1ClashingGAVForced() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        try {
            this.service.initRepositoryStructure(gav, repository, DeploymentMode.FORCED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.never())).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)pomArgumentCaptor.capture());
        Assert.assertNotNull((Object)pomArgumentCaptor.getValue());
        Assert.assertEquals((Object)"groupId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getArtifactId());
        Assert.assertEquals((Object)"version", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getVersion());
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.times((int)1))).deployParentPom((GAV)Mockito.eq((Object)gav));
    }

    @Test
    public void testInitRepositoryStructure2SingleModule() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getDefaultBranch()).thenReturn((Object)"master");
        Mockito.when((Object)repository.getBranchRoot("master")).thenReturn((Object)repositoryRootPath);
        Project project = (Project)Mockito.mock(Project.class);
        Path pomPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)project.getPomXMLPath()).thenReturn((Object)pomPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.projectService.newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED))).thenReturn((Object)project);
        this.service.initRepositoryStructure(pom, "baseUrl", repository, false, DeploymentMode.VALIDATED);
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ((ProjectService)Mockito.verify(this.projectService, (VerificationMode)Mockito.times((int)1))).newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
    }

    @Test
    public void testInitRepositoryStructure2SingleModuleClashingGAV() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Project project = (Project)Mockito.mock(Project.class);
        Path pomPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)project.getPomXMLPath()).thenReturn((Object)pomPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((ProjectService)Mockito.doThrow((Throwable)gae).when(this.projectService)).newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        try {
            this.service.initRepositoryStructure(pom, "baseUrl", repository, false, DeploymentMode.VALIDATED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ((ProjectService)Mockito.verify(this.projectService, (VerificationMode)Mockito.never())).newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.any(DeploymentMode.class));
    }

    @Test
    public void testInitRepositoryStructure2SingleModuleClashingGAVForced() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getDefaultBranch()).thenReturn((Object)"master");
        Mockito.when((Object)repository.getBranchRoot("master")).thenReturn((Object)repositoryRootPath);
        Project project = (Project)Mockito.mock(Project.class);
        Path pomPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)project.getPomXMLPath()).thenReturn((Object)pomPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((ProjectService)Mockito.doThrow((Throwable)gae).when(this.projectService)).newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        Mockito.when((Object)this.projectService.newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.FORCED))).thenReturn((Object)project);
        try {
            this.service.initRepositoryStructure(pom, "baseUrl", repository, false, DeploymentMode.FORCED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.never())).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ((ProjectService)Mockito.verify(this.projectService, (VerificationMode)Mockito.times((int)1))).newProject((Path)Mockito.eq((Object)repositoryRootPath), (POM)Mockito.eq((Object)pom), (String)Mockito.eq((Object)"baseUrl"), (DeploymentMode)Mockito.eq((Object)DeploymentMode.FORCED));
    }

    @Test
    public void testInitRepositoryStructure2MultiModule() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn(Collections.emptySet());
        this.service.initRepositoryStructure(pom, "baseUrl", repository, true, DeploymentMode.VALIDATED);
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)pomArgumentCaptor.capture());
        Assert.assertNotNull((Object)pomArgumentCaptor.getValue());
        Assert.assertEquals((Object)"groupId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getArtifactId());
        Assert.assertEquals((Object)"version", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getVersion());
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.times((int)1))).deployParentPom((GAV)Mockito.eq((Object)gav));
    }

    @Test
    public void testInitRepositoryStructure2MultiModuleClashingGAV() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        try {
            this.service.initRepositoryStructure(pom, "baseUrl", repository, true, DeploymentMode.VALIDATED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.never())).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)Mockito.any(POM.class));
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.never())).deployParentPom((GAV)Mockito.eq((Object)gav));
    }

    @Test
    public void testInitRepositoryStructure2MultiModuleClashingGAVForced() {
        GAV gav = new GAV("groupId", "artifactId", "version");
        POM pom = new POM(gav);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Path repositoryRootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)repository.getAlias()).thenReturn((Object)"alias");
        Mockito.when((Object)repository.getRoot()).thenReturn((Object)repositoryRootPath);
        Mockito.when((Object)this.repositoryResolver.getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0])).thenReturn((Object)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        try {
            this.service.initRepositoryStructure(pom, "baseUrl", repository, true, DeploymentMode.FORCED);
        }
        catch (GAVAlreadyExistsException gAVAlreadyExistsException) {
            // empty catch block
        }
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.never())).getRepositoriesResolvingArtifact((GAV)Mockito.eq((Object)gav), new MavenRepositoryMetadata[0]);
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)1))).create((Path)Mockito.eq((Object)repositoryRootPath), (String)Mockito.eq((Object)""), (POM)pomArgumentCaptor.capture());
        Assert.assertNotNull((Object)pomArgumentCaptor.getValue());
        Assert.assertEquals((Object)"groupId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getArtifactId());
        Assert.assertEquals((Object)"version", (Object)((POM)pomArgumentCaptor.getValue()).getGav().getVersion());
        ((GuvnorM2Repository)Mockito.verify((Object)this.m2service, (VerificationMode)Mockito.times((int)1))).deployParentPom((GAV)Mockito.eq((Object)gav));
    }
}

