/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.model.CommitInfo;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.guvnor.asset.management.social.AssetsPromotedEvent;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CherryPickCopyOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

public class CherryPickCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CherryPickCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResults execute(CommandContext commandContext) throws Exception {
        try {
            String gitRepo = (String)this.getParameter(commandContext, "GitRepository");
            String toBranchName = (String)this.getParameter(commandContext, "ToBranchName");
            String fromBranchName = (String)this.getParameter(commandContext, "FromBranchName");
            List commitsInfos = (List)this.getParameter(commandContext, "CommitsInfos");
            String commitsString = (String)this.getParameter(commandContext, "CommitsString");
            String outcome = "unknown";
            BeanManager beanManager = CDIUtils.lookUpBeanManager(commandContext);
            logger.debug("BeanManager " + beanManager);
            RepositoryService repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
            String repositoryURI = this.readRepositoryURI(repositoryService, gitRepo);
            AssetsPromotedEvent event = this.getSocialEvent(gitRepo, repositoryURI, fromBranchName, toBranchName, commitsInfos, "system");
            try {
                if (commitsString != null && !commitsString.equals("")) {
                    String[] commits = commitsString.split(",");
                    Collections.sort(commitsInfos, new Comparator<CommitInfo>(){

                        @Override
                        public int compare(CommitInfo o1, CommitInfo o2) {
                            if (o1.getCommitDate().before(o2.getCommitDate())) {
                                return -1;
                            }
                            if (o1.getCommitDate().after(o2.getCommitDate())) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    String[] orderedCommits = new String[commits.length];
                    int count = 0;
                    for (CommitInfo c : commitsInfos) {
                        for (String s : commits) {
                            if (!c.getCommitId().equals(s)) continue;
                            orderedCommits[count] = s;
                            ++count;
                        }
                    }
                    IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
                    logger.debug("IoService " + ioService);
                    Path fromBranchPath = ioService.get(URI.create("default://" + fromBranchName + "@" + gitRepo));
                    Path toBranchPath = ioService.get(URI.create("default://" + toBranchName + "@" + gitRepo));
                    CherryPickCopyOption copyOption = new CherryPickCopyOption(orderedCommits);
                    logger.debug("Cherry pick command execution");
                    ioService.copy(fromBranchPath, toBranchPath, new CopyOption[]{copyOption});
                }
                outcome = "success";
            }
            catch (Exception e) {
                outcome = "failure : " + e.getMessage();
                event.addError(outcome);
                logger.error("Error when cherry picking commits from {} to {}", new Object[]{fromBranchName, toBranchName, e});
            }
            finally {
                if (beanManager != null && event != null) {
                    beanManager.fireEvent((Object)event, new Annotation[0]);
                }
            }
            ExecutionResults results = new ExecutionResults();
            results.setData("CherryPickResult", (Object)outcome);
            return results;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }

    private AssetsPromotedEvent getSocialEvent(String repository, String repositoryURI, String sourceBranch, String targetBranch, List<CommitInfo> commitsInfos, String user) {
        TreeSet<String> files = new TreeSet<String>();
        if (commitsInfos != null) {
            for (CommitInfo commitInfo : commitsInfos) {
                List<String> currentFiles = commitInfo.getFiles();
                if (currentFiles == null) continue;
                for (String currentFile : currentFiles) {
                    files.add(currentFile);
                }
            }
        }
        ArrayList<String> promotedFiles = new ArrayList<String>();
        promotedFiles.addAll(files);
        return new AssetsPromotedEvent("PromoteAssets", repository, repositoryURI, sourceBranch, targetBranch, promotedFiles, user, Long.valueOf(System.currentTimeMillis()));
    }

    String readRepositoryURI(RepositoryService repositoryService, String alias) {
        RepositoryInfo repositoryInfo;
        String uri = null;
        RepositoryInfo repositoryInfo2 = repositoryInfo = alias != null ? repositoryService.getRepositoryInfo(alias) : null;
        if (repositoryInfo != null && repositoryInfo.getRoot() != null) {
            uri = repositoryInfo.getRoot().toURI();
        }
        return uri;
    }
}

