/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.DataUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.guvnor.asset.management.social.ProjectDeployedEvent;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

public class MavenDeployProjectCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(MavenDeployProjectCommand.class);

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        try {
            ExecutionResults executionResults = new ExecutionResults();
            String deployOutcome = "UNKNOWN";
            String uri = (String)this.getParameter(ctx, "Uri");
            String branchToBuild = (String)this.getParameter(ctx, "BranchToBuild");
            String projectUri = "default://" + branchToBuild + "@" + uri;
            String gav = (String)this.getParameter(ctx, "GAV");
            String[] gavElements = gav.split(":");
            BeanManager beanManager = CDIUtils.lookUpBeanManager(ctx);
            logger.debug("BeanManager " + beanManager);
            BuildService builder = CDIUtils.createBean(BuildService.class, beanManager, new Annotation[0]);
            logger.debug("Builder " + builder);
            IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
            logger.debug("IoService " + ioService);
            RepositoryService repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
            logger.debug("RepositoryService " + repositoryService);
            ProjectDeployedEvent event = this.getSocialEvent((String)ctx.getData("_ProcessName"), uri, gavElements, repositoryService);
            if (ioService != null) {
                Path projectPath = ioService.get(URI.create(projectUri));
                logger.debug("Project path is " + projectPath);
                ProjectService projectService = (ProjectService)CDIUtils.createBean(new TypeLiteral<ProjectService<?>>(){}.getType(), beanManager, new Annotation[0]);
                Project project = projectService.resolveProject(Paths.convert((Path)projectPath));
                BuildResults results = new BuildResults(project.getPom().getGav());
                try {
                    results = builder.buildAndDeploy(project, true);
                }
                catch (GAVAlreadyExistsException gae) {
                    results.addAllBuildMessages(this.convertToBuildMessages(gae));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Errors " + results.getErrorMessages().size());
                    logger.debug("Warnings " + results.getWarningMessages().size());
                    logger.debug("Info " + results.getInformationMessages().size());
                }
                if (results.getErrorMessages().isEmpty()) {
                    deployOutcome = "SUCCESSFUL";
                } else {
                    deployOutcome = "FAILURE";
                    for (BuildMessage message : results.getMessages()) {
                        event.addError(message.getText());
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Error " + message.getText());
                    }
                    PublishBatchMessagesEvent publishMessage = new PublishBatchMessagesEvent();
                    publishMessage.setCleanExisting(true);
                    ArrayList<SystemMessage> messageList = new ArrayList<SystemMessage>();
                    SystemMessage buildOutcomeMsg = new SystemMessage();
                    buildOutcomeMsg.setLevel(Level.ERROR);
                    buildOutcomeMsg.setText("Maven install process failed for project " + project.getProjectName());
                    buildOutcomeMsg.setMessageType("BuildSystem");
                    messageList.add(buildOutcomeMsg);
                    beanManager.fireEvent((Object)publishMessage, new Annotation[0]);
                }
                executionResults.setData("Errors", (Object)results.getErrorMessages());
                executionResults.setData("Warnings", (Object)results.getWarningMessages());
                executionResults.setData("Info", (Object)results.getInformationMessages());
                executionResults.setData("GAV", (Object)results.getGAV().toString());
                beanManager.fireEvent((Object)event, new Annotation[0]);
            }
            executionResults.setData("MavenDeployOutcome", (Object)deployOutcome);
            return executionResults;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }

    private List<BuildMessage> convertToBuildMessages(GAVAlreadyExistsException gae) {
        GAV gav = gae.getGAV();
        ArrayList<BuildMessage> messages = new ArrayList<BuildMessage>();
        for (MavenRepositoryMetadata md : gae.getRepositories()) {
            messages.add(this.convertToBuildMessage(gav, md));
        }
        return messages;
    }

    private BuildMessage convertToBuildMessage(GAV gav, MavenRepositoryMetadata md) {
        BuildMessage message = new BuildMessage();
        message.setLevel(Level.ERROR);
        message.setText("Artifact '" + gav.toString() + "' was found at '" + md.getId() + " " + md.getUrl() + " " + md.getSource() + "'.");
        return message;
    }

    private ProjectDeployedEvent getSocialEvent(String processName, String uriParam, String[] gavElements, RepositoryService repositoryService) {
        String repository = null;
        String projectName = null;
        String repositoryURI = null;
        if (uriParam != null && uriParam.indexOf("/") > 0) {
            repository = uriParam.substring(0, uriParam.indexOf("/"));
            projectName = uriParam.substring(uriParam.indexOf("/") + 1, uriParam.length());
            repositoryURI = DataUtils.readRepositoryURI(repositoryService, repository);
        }
        ProjectDeployedEvent event = new ProjectDeployedEvent(processName, repository, repositoryURI, "system", Long.valueOf(System.currentTimeMillis()));
        event.setDeployType(ProjectDeployedEvent.DeployType.MAVEN);
        event.setProjectName(projectName);
        if (gavElements != null && gavElements.length == 3) {
            event.setGroupId(gavElements[0]);
            event.setArtifactId(gavElements[1]);
            event.setVersion(gavElements[2]);
        }
        return event;
    }
}

