/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.net.URI;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

public class CreateBranchCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CreateBranchCommand.class);

    public ExecutionResults execute(CommandContext commandContext) throws Exception {
        try {
            String gitRepo = (String)this.getParameter(commandContext, "GitRepository");
            String branchName = (String)this.getParameter(commandContext, "BranchName");
            String branchOriginName = (String)this.getParameter(commandContext, "OriginBranchName");
            String version = (String)this.getParameter(commandContext, "Version");
            if (version != null && !version.isEmpty()) {
                branchName = branchName + "-" + version;
            }
            BeanManager beanManager = CDIUtils.lookUpBeanManager(commandContext);
            logger.debug("BeanManager " + beanManager);
            IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
            logger.debug("IoService " + ioService);
            Path branchPath = ioService.get(URI.create("default://" + branchName + "@" + gitRepo));
            Path branchOriginPath = ioService.get(URI.create("default://" + branchOriginName + "@" + gitRepo));
            ioService.copy(branchOriginPath, branchPath, new CopyOption[0]);
            beanManager.fireEvent((Object)new NewBranchEvent(gitRepo, branchName, Paths.convert((Path)branchPath), Long.valueOf(System.currentTimeMillis())), new Annotation[0]);
            ExecutionResults results = new ExecutionResults();
            return results;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }
}

