/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.model.BranchInfo;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBranchesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(ListBranchesCommand.class);

    public ExecutionResults execute(CommandContext commandContext) throws Exception {
        try {
            String gitRepo = (String)this.getParameter(commandContext, "GitRepository");
            BeanManager beanManager = CDIUtils.lookUpBeanManager(commandContext);
            logger.debug("BeanManager " + beanManager);
            RepositoryService repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
            Repository repository = repositoryService.getRepository(gitRepo);
            if (repository == null) {
                throw new IllegalArgumentException("No repository found for alias " + gitRepo);
            }
            Collection branchNames = repository.getBranches();
            ArrayList<BranchInfo> branchInfos = new ArrayList<BranchInfo>();
            for (String branch : branchNames) {
                branchInfos.add(new BranchInfo("default://" + branch + "@" + gitRepo, branch));
            }
            ExecutionResults results = new ExecutionResults();
            results.setData("Branches", branchInfos);
            return results;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }
}

