/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.guvnor.asset.management.model.BuildProjectStructureEvent;
import org.guvnor.asset.management.model.ConfigureRepositoryEvent;
import org.guvnor.asset.management.model.PromoteChangesEvent;
import org.guvnor.asset.management.model.ReleaseProjectEvent;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.internal.executor.api.ExecutorService;

@Service
@ApplicationScoped
public class AssetManagementServiceImpl
implements AssetManagementService {
    private Event<ConfigureRepositoryEvent> configureRepositoryEvent;
    private Event<BuildProjectStructureEvent> buildProjectStructureEvent;
    private Event<PromoteChangesEvent> promoteChangesEvent;
    private Event<ReleaseProjectEvent> releaseProjectEvent;
    private ConfigurationService configurationService;
    private Instance<ProjectService<?>> projectService;
    private boolean supportRuntimeDeployment;

    public AssetManagementServiceImpl() {
    }

    @Inject
    public AssetManagementServiceImpl(Event<ConfigureRepositoryEvent> configureRepositoryEvent, Event<BuildProjectStructureEvent> buildProjectStructureEvent, Event<PromoteChangesEvent> promoteChangesEvent, Event<ReleaseProjectEvent> releaseProjectEvent, ConfigurationService configurationService, Instance<ProjectService<?>> projectService) {
        this.configureRepositoryEvent = configureRepositoryEvent;
        this.buildProjectStructureEvent = buildProjectStructureEvent;
        this.promoteChangesEvent = promoteChangesEvent;
        this.releaseProjectEvent = releaseProjectEvent;
        this.configurationService = configurationService;
        this.projectService = projectService;
    }

    @PostConstruct
    public void init() {
        String supportRuntime = "true";
        List globalConfigGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
        for (ConfigGroup globalConfigGroup : globalConfigGroups) {
            if (!"settings".equals(globalConfigGroup.getName())) continue;
            supportRuntime = globalConfigGroup.getConfigItemValue("support.runtime.deploy");
            break;
        }
        this.supportRuntimeDeployment = Boolean.parseBoolean(supportRuntime);
    }

    public void configureRepository(String repository, String sourceBranch, String devBranch, String releaseBranch, String version) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RepositoryName", repository);
        params.put("SourceBranchName", sourceBranch);
        params.put("DevBranchName", devBranch);
        params.put("RelBranchName", releaseBranch);
        params.put("Version", version);
        params.put("Owner", ExecutorService.EXECUTOR_ID);
        this.configureRepositoryEvent.fire((Object)new ConfigureRepositoryEvent(params));
    }

    public void buildProject(String repository, String branch, String project, String userName, String password, String serverURL, Boolean deployToRuntime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ProjectURI", repository + "/" + project);
        params.put("BranchName", branch);
        params.put("Username", userName);
        params.put("Password", this.encodePassword(password));
        params.put("ExecServerURL", serverURL);
        params.put("DeployToRuntime", Boolean.TRUE.equals(deployToRuntime));
        params.put("Owner", ExecutorService.EXECUTOR_ID);
        this.buildProjectStructureEvent.fire((Object)new BuildProjectStructureEvent(params));
    }

    public void promoteChanges(String repository, String sourceBranch, String destBranch) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RepositoryName", repository);
        params.put("SourceBranchName", sourceBranch);
        params.put("TargetBranchName", destBranch);
        params.put("Owner", ExecutorService.EXECUTOR_ID);
        this.promoteChangesEvent.fire((Object)new PromoteChangesEvent(params));
    }

    public void releaseProject(String repository, String branch, String userName, String password, String serverURL, Boolean deployToRuntime, String version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ProjectURI", repository);
        params.put("ToReleaseBranch", branch);
        params.put("ToReleaseVersion", version);
        params.put("Username", userName);
        params.put("Password", this.encodePassword(password));
        params.put("ExecServerURL", serverURL);
        params.put("ValidForRelease", Boolean.TRUE);
        params.put("DeployToRuntime", Boolean.TRUE.equals(deployToRuntime));
        params.put("Owner", ExecutorService.EXECUTOR_ID);
        this.releaseProjectEvent.fire((Object)new ReleaseProjectEvent(params));
    }

    public boolean supportRuntimeDeployment() {
        return this.supportRuntimeDeployment;
    }

    public Set<Project> getProjects(Repository repository, String branch) {
        return ((ProjectService)this.projectService.get()).getProjects(repository, branch);
    }

    protected String encodePassword(String password) {
        if (password == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])password.getBytes()));
    }
}

