/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.asset.management.social.ProcessEndEvent;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

public class ProcessEndEventAdapter
implements SocialAdapter<ProcessEndEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<ProcessEndEvent> eventToIntercept() {
        return ProcessEndEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.PROCESS_END;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        ProcessEndEvent event = (ProcessEndEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.PROCESS_END.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias() != null ? event.getRepositoryAlias() : "<unknown>", event.getRootURI() != null ? event.getRootURI() : "<unknown>").withAdicionalInfo(new String[]{this.getAdditionalInfo(event.getProcessName(), event.getRepositoryAlias(), event)});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(String process, String repo, ProcessEndEvent event) {
        if ("ConfigureRepository".equals(process)) {
            return this.constants.configure_repository_end(repo);
        }
        if ("PromoteAssets".equals(process)) {
            return this.constants.promote_assets_end(repo);
        }
        if ("BuildProject".equals(process)) {
            String _BP_BuildOutcome = (String)event.getParams().get("BP_BuildOutcome");
            String _BP_GAV = (String)event.getParams().get("BP_GAV");
            String _BP_MavenDeployOutcome = (String)event.getParams().get("BP_MavenDeployOutcome");
            String _BP_ExecServerURL = (String)event.getParams().get("BP_ExecServerURL");
            String _BP_Username = (String)event.getParams().get("BP_Username");
            String _BP_DeployToRuntime = (String)event.getParams().get("BP_DeployToRuntime");
            boolean deploySelected = _BP_DeployToRuntime != null && Boolean.parseBoolean(_BP_DeployToRuntime);
            String project = (String)event.getParams().get("project");
            String branch = (String)event.getParams().get("branch");
            if ("FAILURE".equals(_BP_MavenDeployOutcome)) {
                return this.constants.build_project_end_with_errors(project);
            }
            if ("SUCCESSFUL".equals(_BP_MavenDeployOutcome) && deploySelected) {
                return this.constants.build_project_deploy_runtime_success(project);
            }
            if ("SUCCESSFUL".equals(_BP_MavenDeployOutcome) && !deploySelected) {
                return this.constants.build_project_deploy_runtime_skipped(project);
            }
            return this.constants.build_project_end(project);
        }
        if ("ReleaseProject".equals(process)) {
            return this.constants.release_project_end(repo);
        }
        return "";
    }
}

