/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import javax.enterprise.event.Event;
import org.guvnor.asset.management.backend.service.ManagedStatusUpdater;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ManagedStatusUpdaterTest {
    @Mock
    private Repository originalRepository;
    @Mock
    private Repository updatedRepository;
    @Mock
    private RepositoryService repositoryService;
    private Event<RepositoryEnvironmentUpdatedEvent> repositoryUpdatedEvent;
    private ManagedStatusUpdater managedStatusUpdater;
    @Captor
    ArgumentCaptor<RepositoryEnvironmentConfigurations> repositoryEnvironmentConfigurationsCaptor;
    private RepositoryEnvironmentUpdatedEvent updatedEvent;

    @Before
    public void setUp() throws Exception {
        this.repositoryUpdatedEvent = new EventSourceMock<RepositoryEnvironmentUpdatedEvent>(){

            public void fire(RepositoryEnvironmentUpdatedEvent event) {
                ManagedStatusUpdaterTest.this.updatedEvent = event;
            }
        };
        Mockito.when((Object)this.repositoryService.updateRepositoryConfiguration((Repository)Mockito.eq((Object)this.originalRepository), (RepositoryEnvironmentConfigurations)Mockito.any(RepositoryEnvironmentConfigurations.class))).thenReturn((Object)this.updatedRepository);
        this.managedStatusUpdater = new ManagedStatusUpdater(this.repositoryService, this.repositoryUpdatedEvent);
    }

    @Test
    public void testMakeManaged() throws Exception {
        this.managedStatusUpdater.updateManagedStatus(this.originalRepository, true);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).updateRepositoryConfiguration((Repository)Mockito.eq((Object)this.originalRepository), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.capture());
        Assert.assertTrue((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.getValue()).isManaged());
    }

    @Test
    public void testMakeNotManaged() throws Exception {
        this.managedStatusUpdater.updateManagedStatus(this.originalRepository, false);
        ((RepositoryService)Mockito.verify((Object)this.repositoryService)).updateRepositoryConfiguration((Repository)Mockito.eq((Object)this.originalRepository), (RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.capture());
        Assert.assertFalse((boolean)((RepositoryEnvironmentConfigurations)this.repositoryEnvironmentConfigurationsCaptor.getValue()).isManaged());
    }

    @Test
    public void testUseUpdatedRepositoryForTheEvent() throws Exception {
        this.managedStatusUpdater.updateManagedStatus(this.originalRepository, true);
        Assert.assertEquals((Object)this.updatedRepository, (Object)this.updatedEvent.getUpdatedRepository());
    }

    @Test
    public void testReturnsUpdatedRepository() throws Exception {
        Assert.assertEquals((Object)this.updatedRepository, (Object)this.managedStatusUpdater.updateManagedStatus(this.originalRepository, true));
    }
}

