/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.service.ManagedStatusUpdater;
import org.guvnor.asset.management.backend.service.RepositoryStructureModelLoader;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.test.TestTempFileSystem;
import org.guvnor.test.WeldJUnitRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=WeldJUnitRunner.class)
public class RepositoryStructureModelLoaderTest {
    @InjectMocks
    RepositoryStructureModelLoader loader;
    @Mock
    private POMService pomService;
    @Mock
    private ProjectService<? extends Project> projectService;
    @Mock
    private ManagedStatusUpdater managedStatusUpdater;
    @Mock
    private MetadataService metadataService;
    @Inject
    private TestTempFileSystem testFileSystem;
    private Path myprojectMasterBranchRoot;
    private Path myProjectPom;
    private Repository repository;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.repository.getEnvironment()).thenReturn(null);
        this.myprojectMasterBranchRoot = this.testFileSystem.createTempDirectory("/myproject");
        this.myProjectPom = this.testFileSystem.createTempFile("myproject/pom.xml");
        Mockito.when((Object)this.repository.getBranchRoot("master")).thenReturn((Object)this.myprojectMasterBranchRoot);
    }

    @After
    public void tearDown() throws Exception {
        this.testFileSystem.tearDown();
    }

    @Test
    public void testNullRepo() throws Exception {
        RepositoryStructureModel structureModel = this.loader.load(null, "master", true);
        Assert.assertNull((Object)structureModel);
    }

    @Test
    public void testLoadProjectInRoot() throws Exception {
        POM pom = new POM();
        Metadata metadata = new Metadata();
        this.addMyProjectToRepositoryRoot(pom, metadata, new String[0]);
        this.makeManaged(this.repository);
        RepositoryStructureModel model = this.loader.load(this.repository, "master", false);
        Assert.assertTrue((boolean)model.isManaged());
        Assert.assertEquals((Object)pom, (Object)model.getPOM());
        Assert.assertEquals((Object)metadata, (Object)model.getPOMMetaData());
        Assert.assertEquals((Object)this.myProjectPom, (Object)model.getPathToPOM());
        Assert.assertTrue((boolean)model.getModulesProject().isEmpty());
    }

    @Test
    public void testNoModules() throws Exception {
        this.addMyProjectToRepositoryRoot(new POM(), new Metadata(), new String[0]);
        RepositoryStructureModel model = this.loader.load(this.repository, "master", true);
        Assert.assertTrue((boolean)model.getModulesProject().isEmpty());
    }

    @Test
    public void testModulesExist() throws Exception {
        this.addMyProjectToRepositoryRoot(new POM(), new Metadata(), "module1", "module2");
        RepositoryStructureModel model = this.loader.load(this.repository, "master", true);
        Assert.assertEquals((long)2L, (long)model.getModulesProject().size());
    }

    @Test
    public void testLoadManaged() throws Exception {
        this.makeManaged(this.repository);
        this.addMyProjectToRepositoryRoot(new POM(), new Metadata(), new String[0]);
        this.loader.load(this.repository, "master", false);
        ((ManagedStatusUpdater)Mockito.verify((Object)this.managedStatusUpdater, (VerificationMode)Mockito.never())).updateManagedStatus(this.repository, true);
    }

    @Test
    public void testUpdateToManaged() throws Exception {
        this.addMyProjectToRepositoryRoot(new POM(), new Metadata(), new String[0]);
        this.loader.load(this.repository, "master", false);
        ((ManagedStatusUpdater)Mockito.verify((Object)this.managedStatusUpdater)).updateManagedStatus(this.repository, true);
    }

    private void addMyProjectToRepositoryRoot(POM pom, Metadata metadata, String ... moduleNames) {
        ArrayList<String> modules = new ArrayList<String>();
        for (String moduleName : moduleNames) {
            modules.add(moduleName);
        }
        Project project = new Project(this.myprojectMasterBranchRoot, this.myProjectPom, "myproject", modules);
        Mockito.when((Object)this.projectService.resolveToParentProject(this.myprojectMasterBranchRoot)).thenReturn((Object)project);
        Mockito.when((Object)this.pomService.load(this.myProjectPom)).thenReturn((Object)pom);
        Mockito.when((Object)this.metadataService.getMetadata(this.myProjectPom)).thenReturn((Object)metadata);
    }

    private void makeManaged(Repository repository) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("managed", Boolean.TRUE);
        Mockito.when((Object)repository.getEnvironment()).thenReturn(map);
    }
}

