/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.TypeLiteral;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

public class ConfigureDevelopmentBranchCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureDevelopmentBranchCommand.class);

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        try {
            ExecutionResults executionResults = new ExecutionResults();
            String repository = (String)this.getParameter(ctx, "GitRepository");
            if (repository.endsWith(".git")) {
                repository = repository.substring(0, repository.length() - 4);
            }
            String branchToUpdate = (String)this.getParameter(ctx, "BranchName");
            String version = (String)this.getParameter(ctx, "Version");
            if (version == null) {
                version = "1.0.0";
            } else if (!version.endsWith("-SNAPSHOT")) {
                version = version.concat("-SNAPSHOT");
            }
            BeanManager beanManager = CDIUtils.lookUpBeanManager(ctx);
            logger.debug("BeanManager " + beanManager);
            POMService pomService = CDIUtils.createBean(POMService.class, beanManager, new Annotation[0]);
            logger.debug("POMService " + pomService);
            IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
            logger.debug("IoService " + ioService);
            if (ioService != null) {
                ProjectService projectService = (ProjectService)CDIUtils.createBean(new TypeLiteral<ProjectService<?>>(){}.getType(), beanManager, new Annotation[0]);
                RepositoryService repositoryService = CDIUtils.createBean(RepositoryService.class, beanManager, new Annotation[0]);
                logger.debug("RepositoryService " + repositoryService);
                if (repositoryService != null) {
                    Repository repo = repositoryService.getRepository(repository);
                    repo = repositoryService.getRepository(repo.getBranchRoot(branchToUpdate + "-" + version));
                    logger.debug("Updated repository " + repo);
                    Set<Project> projects = this.getProjects(repo, ioService, projectService);
                    for (Project project : projects) {
                        POM pom = (POM)pomService.load(project.getPomXMLPath());
                        pom.getGav().setVersion(version);
                        pomService.save(project.getPomXMLPath(), (Object)pom, null, "Update project version on development branch");
                        executionResults.setData(project.getProjectName() + "-GAV", (Object)pom.getGav().toString());
                    }
                }
            }
            return executionResults;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }

    private Set<Project> getProjects(Repository repository, IOService ioService, ProjectService projectService) {
        HashSet<Project> authorizedProjects = new HashSet<Project>();
        if (repository == null) {
            return authorizedProjects;
        }
        Path repositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot());
        DirectoryStream nioRepositoryPaths = ioService.newDirectoryStream(repositoryRoot);
        for (Path nioRepositoryPath : nioRepositoryPaths) {
            org.uberfire.backend.vfs.Path projectPath;
            Project project;
            if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0]) || (project = projectService.resolveProject(projectPath = Paths.convert((Path)nioRepositoryPath))) == null) continue;
            authorizedProjects.add(project);
        }
        return authorizedProjects;
    }
}

