/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.command;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.guvnor.asset.management.backend.AssetManagementRuntimeException;
import org.guvnor.asset.management.backend.command.AbstractCommand;
import org.guvnor.asset.management.backend.model.CommitInfo;
import org.guvnor.asset.management.backend.utils.CDIUtils;
import org.guvnor.asset.management.backend.utils.NamedLiteral;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.util.JGitUtil;

public class ListCommitsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(ListCommitsCommand.class);
    private static final String DEFAULT_FILER_REGEX = ".*\\/\\..*";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public ExecutionResults execute(CommandContext commandContext) throws Exception {
        try {
            ExecutionResults results = new ExecutionResults();
            String gitRepo = (String)this.getParameter(commandContext, "GitRepository");
            String branchName = (String)this.getParameter(commandContext, "BranchName");
            String compareToBranchName = (String)this.getParameter(commandContext, "CompareToBranchName");
            String fromDate = (String)this.getParameter(commandContext, "FromDate");
            Date startCommitDate = null;
            if (fromDate != null) {
                startCommitDate = dateFormat.parse(fromDate);
            }
            LinkedHashSet<String> existingCommits = new LinkedHashSet<String>();
            BeanManager beanManager = CDIUtils.lookUpBeanManager(commandContext);
            logger.debug("BeanManager " + beanManager);
            IOService ioService = CDIUtils.createBean(IOService.class, beanManager, new Annotation[]{new NamedLiteral("ioStrategy")});
            logger.debug("IoService " + ioService);
            Path branchPath = ioService.get(URI.create("git://" + branchName + "@" + gitRepo));
            if (compareToBranchName != null) {
                Path compareToBranchPath = ioService.get(URI.create("git://" + compareToBranchName + "@" + gitRepo));
                VersionAttributeView compareView = (VersionAttributeView)ioService.getFileAttributeView(compareToBranchPath, VersionAttributeView.class);
                List compareLogs = compareView.readAttributes().history().records();
                for (VersionRecord ccommit : compareLogs) {
                    if (startCommitDate != null && startCommitDate.after(ccommit.date())) break;
                    existingCommits.add(ccommit.id());
                }
            }
            VersionAttributeView vinit = (VersionAttributeView)ioService.getFileAttributeView(branchPath, VersionAttributeView.class);
            List logs = vinit.readAttributes().history().records();
            ArrayList<CommitInfo> commits = new ArrayList<CommitInfo>();
            JGitFileSystem fs = (JGitFileSystem)ioService.getFileSystem(branchPath.toUri());
            Collections.reverse(logs);
            for (VersionRecord commit : logs) {
                if (existingCommits.contains(commit.id())) continue;
                String shortMessage = commit.comment();
                Date commitDate = commit.date();
                if (startCommitDate != null && startCommitDate.after(commitDate)) break;
                List<String> files = this.getFilesInCommit(fs.gitRepo().getRepository(), JGitUtil.resolveObjectId((Git)fs.gitRepo(), (String)commit.id()));
                CommitInfo commitInfo = new CommitInfo(commit.id(), shortMessage, commit.author(), commitDate, files);
                commits.add(commitInfo);
                logger.debug("Found commit {}", (Object)commitInfo);
            }
            String commitsString = this.dumpToStringCommit(commits);
            Map<String, List<String>> commitsPerFileMap = this.sortByFileName(commits);
            results.setData("Commits", commits);
            results.setData("CommitsPerFile", commitsPerFileMap);
            results.setData("CommitsPerFileString", (Object)this.dumpToStringFiles(commitsPerFileMap.keySet()));
            results.setData("CommitsPerFileMap", commitsPerFileMap);
            results.setData("CommitsString", (Object)commitsString);
            return results;
        }
        catch (Throwable e) {
            throw new AssetManagementRuntimeException(e);
        }
    }

    protected String dumpToStringCommit(List<CommitInfo> commits) {
        StringBuilder commitString = new StringBuilder();
        for (CommitInfo commit : commits) {
            commitString.append(commit.getCommitId()).append(",");
        }
        return commitString.toString();
    }

    protected String dumpToStringFiles(Set<String> files) {
        StringBuilder filesString = new StringBuilder();
        for (String file : files) {
            filesString.append(file).append(",");
        }
        return filesString.toString();
    }

    protected Map<String, List<String>> sortByFileName(List<CommitInfo> commits) {
        HashMap<String, List<String>> sorted = new HashMap<String, List<String>>();
        if (commits == null) {
            return sorted;
        }
        for (CommitInfo commit : commits) {
            List<String> files = commit.getFiles();
            if (files == null) continue;
            for (String file : files) {
                if (file.matches(DEFAULT_FILER_REGEX)) continue;
                ArrayList<String> commitsPerFile = (ArrayList<String>)sorted.get(file);
                if (commitsPerFile == null) {
                    commitsPerFile = new ArrayList<String>();
                    sorted.put(file, commitsPerFile);
                }
                commitsPerFile.add(commit.getCommitId());
            }
        }
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getFilesInCommit(Repository repository, ObjectId commitId) {
        ArrayList<String> list = new ArrayList<String>();
        RevWalk rw = new RevWalk(repository);
        try {
            RevCommit commit = rw.parseCommit((AnyObjectId)commitId);
            if (commit == null) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            if (commit.getParentCount() == 0) {
                TreeWalk tw = new TreeWalk(repository);
                tw.reset();
                tw.setRecursive(true);
                tw.addTree((AnyObjectId)commit.getTree());
                while (tw.next()) {
                    list.add(tw.getPathString());
                }
                tw.close();
            } else {
                RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                DiffFormatter df = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
                df.setRepository(repository);
                df.setDiffComparator(RawTextComparator.DEFAULT);
                df.setDetectRenames(true);
                List diffs = df.scan(parent.getTree(), commit.getTree());
                for (DiffEntry diff : diffs) {
                    if (diff.getChangeType().equals((Object)DiffEntry.ChangeType.DELETE)) {
                        list.add(diff.getOldPath());
                        continue;
                    }
                    if (diff.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME)) {
                        list.add(diff.getNewPath());
                        continue;
                    }
                    list.add(diff.getNewPath());
                }
            }
        }
        catch (Throwable t) {
            logger.error("Unable to determine files in commit due to {} in repository {}", (Object)t, (Object)repository);
        }
        finally {
            rw.dispose();
        }
        return list;
    }
}

