/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.service.ManagedStatusUpdater;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public class RepositoryStructureModelLoader {
    @Inject
    private POMService pomService;
    @Inject
    private ProjectService<? extends Project> projectService;
    @Inject
    private ManagedStatusUpdater managedStatusUpdater;
    @Inject
    private MetadataService metadataService;

    public RepositoryStructureModel load(Repository repository, String branch, boolean includeModules) {
        if (repository == null) {
            return null;
        }
        Project project = this.projectService.resolveToParentProject(repository.getBranchRoot(branch));
        if (project != null) {
            return this.getModel(repository, includeModules, project);
        }
        return this.getModel(repository, branch);
    }

    private RepositoryStructureModel getModel(Repository repository, String branch) {
        RepositoryStructureModel model = new RepositoryStructureModel();
        Set repositoryProjects = this.projectService.getProjects(repository, branch);
        switch (this.getManagedStatus(repository)) {
            case MANAGED: {
                model.setManaged(Boolean.valueOf(true));
                break;
            }
            case UNMANAGED: {
                model.setManaged(Boolean.valueOf(false));
                break;
            }
            case UNKNOWN: {
                if (repositoryProjects.isEmpty()) {
                    return null;
                }
                if (repositoryProjects.size() <= 1) break;
                this.managedStatusUpdater.updateManagedStatus(repository, false);
            }
        }
        model.setOrphanProjects(new ArrayList(repositoryProjects));
        for (Project orphanProject : repositoryProjects) {
            POM pom = (POM)this.pomService.load(orphanProject.getPomXMLPath());
            model.getOrphanProjectsPOM().put(orphanProject.getIdentifier(), pom);
        }
        return model;
    }

    private RepositoryStructureModel getModel(Repository repository, boolean includeModules, Project project) {
        RepositoryStructureModel model = new RepositoryStructureModel();
        switch (this.getManagedStatus(repository)) {
            case MANAGED: {
                model.setManaged(Boolean.valueOf(true));
                break;
            }
            case UNMANAGED: {
                model.setManaged(Boolean.valueOf(false));
                break;
            }
        }
        if (!model.isManaged().booleanValue()) {
            this.managedStatusUpdater.updateManagedStatus(repository, true);
            model.setManaged(Boolean.valueOf(true));
        }
        model.setPOM((POM)this.pomService.load(project.getPomXMLPath()));
        model.setPOMMetaData(this.metadataService.getMetadata(project.getPomXMLPath()));
        model.setPathToPOM(project.getPomXMLPath());
        model.setModules(project.getModules());
        if (includeModules && project.getModules() != null) {
            model.setModulesProject(this.getModuleProjects(project.getRootPath(), project.getModules()));
        }
        return model;
    }

    private Map<String, Project> getModuleProjects(org.uberfire.backend.vfs.Path projectRootPath, Collection<String> moduleNames) {
        HashMap<String, Project> result = new HashMap<String, Project>();
        Path parentPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRootPath);
        for (String moduleName : moduleNames) {
            result.put(moduleName, this.projectService.resolveProject(Paths.convert((Path)parentPath.resolve(moduleName))));
        }
        return result;
    }

    private ManagedStatus getManagedStatus(Repository repository) {
        if (repository.getEnvironment() != null) {
            if (((Boolean)repository.getEnvironment().get("managed")).booleanValue()) {
                return ManagedStatus.MANAGED;
            }
            return ManagedStatus.UNMANAGED;
        }
        return ManagedStatus.UNKNOWN;
    }

    static enum ManagedStatus {
        MANAGED,
        UNMANAGED,
        UNKNOWN;

    }
}

