/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.asset.management.social.RepositoryChangeEvent;
import org.kie.uberfire.social.activities.model.SocialActivitiesEvent;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.repository.SocialUserRepository;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialCommandTypeFilter;

public class RepositoryChangeEventAdapter
implements SocialAdapter<RepositoryChangeEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<RepositoryChangeEvent> eventToIntercept() {
        return RepositoryChangeEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.REPOSITORY_CHANGE;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        RepositoryChangeEvent event = (RepositoryChangeEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.REPOSITORY_CHANGE.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias() != null ? event.getRepositoryAlias() : "<unknown>", event.getRootURI() != null ? event.getRootURI() : "<unknown>").withAdicionalInfo(new String[]{this.getAdditionalInfo(event)});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(RepositoryChangeEvent event) {
        StringBuilder info = new StringBuilder();
        if (event.getChangeType() == RepositoryChangeEvent.ChangeType.VERSION_CHANGED) {
            info.append(this.constants.release_project_version_change_success(event.getRepositoryAlias(), (String)event.getParams().get("version")));
        }
        return info.toString();
    }
}

